/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client;

import com.naterbobber.darkerdepths.init.DDItems;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DynamicLightHandler {
    private static final Minecraft INSTANCE = Minecraft.getInstance();
    public static final Map<BlockPos, LightValue> LIGHT_SOURCES = new ConcurrentHashMap<BlockPos, LightValue>();
    private static final int LIGHT_SCAN_RADIUS = 64;

    public static void onClientTick() {
        if (DynamicLightHandler.INSTANCE.player == null || DynamicLightHandler.INSTANCE.level == null) {
            return;
        }
        LIGHT_SOURCES.forEach((pos, value) -> {
            value.shouldKeep = false;
        });
        AABB searchArea = DynamicLightHandler.INSTANCE.player.getBoundingBox().inflate(64.0);
        DynamicLightHandler.INSTANCE.level.getEntitiesOfClass(LivingEntity.class, searchArea, DynamicLightHandler::shouldGlow).forEach(entity -> {
            BlockPos lightPos = entity.getOnPos();
            if (!DynamicLightHandler.INSTANCE.level.getBlockState(lightPos).isSolid()) {
                lightPos = entity.blockPosition();
            }
            DynamicLightHandler.LIGHT_SOURCES.computeIfAbsent((BlockPos)lightPos, (Function<BlockPos, LightValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onClientTick$1(net.minecraft.core.BlockPos ), (Lnet/minecraft/core/BlockPos;)Lcom/naterbobber/darkerdepths/client/DynamicLightHandler$LightValue;)()).shouldKeep = true;
        });
        if (!LIGHT_SOURCES.isEmpty()) {
            LIGHT_SOURCES.forEach((pos, value) -> DynamicLightHandler.INSTANCE.level.getChunkSource().getLightEngine().checkBlock(pos));
            LIGHT_SOURCES.entrySet().removeIf(entry -> !((LightValue)entry.getValue()).shouldKeep);
        }
    }

    public static boolean shouldGlow(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.HEAD).getItem() == DDItems.GLOWSHROOM_CAP.get() && !entity.isSpectator();
    }

    private static /* synthetic */ LightValue lambda$onClientTick$1(BlockPos k) {
        return new LightValue();
    }

    public static class LightValue {
        public boolean shouldKeep = true;
    }
}

