/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VoidSoulFlameSmokeParticle
extends TextureSheetParticle {
    protected VoidSoulFlameSmokeParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        double randomRange = 0.025;
        this.x += Math.random() * randomRange - randomRange / 2.0;
        this.z += Math.random() * randomRange - randomRange / 2.0;
        this.y -= (double)0.02f;
        this.quadSize *= 2.0f + this.random.nextFloat() / 2.0f;
        this.lifetime = 20;
        this.gravity = 0.0f;
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        float growthRate = 0.975f;
        float compensateHeight = 0.0f;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.y += 0.0;
        this.quadSize *= 0.975f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VoidSoulFlameSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public VoidSoulFlameSmokeFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public TextureSheetParticle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            VoidSoulFlameSmokeParticle particle = new VoidSoulFlameSmokeParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

