/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client.render.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.naterbobber.darkerdepths.client.models.GlowshroomMonsterModel;
import com.naterbobber.darkerdepths.client.render.renderers.layers.DDCustomRenderTypeLayer;
import com.naterbobber.darkerdepths.entities.GlowshroomMonsterEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3d;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public class GlowshroomMonsterRenderer
extends GeoEntityRenderer<GlowshroomMonsterEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)"textures/entity/glowshroom_monster/glowshroom_monster_glowmask.png");
    private int currentTick = -1;

    public GlowshroomMonsterRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new GlowshroomMonsterModel());
        this.addRenderLayer(new DDCustomRenderTypeLayer(this, RenderType.eyes((ResourceLocation)TEXTURE)));
    }

    public void renderFinal(PoseStack poseStack, GlowshroomMonsterEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        int attackTick = ((GlowshroomMonsterEntity)this.animatable).getAttackTick();
        if (attackTick == 24) {
            this.model.getBone("particle").ifPresent(particle -> {
                RandomSource rand = animatable.getRandom();
                Vector3d particlePos = particle.getWorldPosition();
                double randomOffset = 1.0;
                if (rand.nextDouble() > 0.8) {
                    animatable.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, particlePos.x() + rand.nextDouble() / randomOffset - 0.5 / randomOffset, particlePos.y() + rand.nextDouble() / randomOffset - 0.5 / randomOffset + 0.5, particlePos.z() + rand.nextDouble() / randomOffset - 0.5 / randomOffset, rand.nextDouble() - 0.5, -rand.nextDouble(), rand.nextDouble() - 0.5);
                }
            });
        }
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, color);
    }
}

