/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.data.assets;

import com.naterbobber.darkerdepths.block.generic.ConnectedPillarBlock;
import com.naterbobber.darkerdepths.block.generic.IRelationalBlock;
import com.naterbobber.darkerdepths.block.generic.RelationalButtonBlock;
import com.naterbobber.darkerdepths.block.generic.RelationalFenceBlock;
import com.naterbobber.darkerdepths.block.generic.RelationalFenceGateBlock;
import com.naterbobber.darkerdepths.block.generic.RelationalPressurePlateBlock;
import com.naterbobber.darkerdepths.block.generic.RelationalSlabBlock;
import com.naterbobber.darkerdepths.block.generic.RelationalStairBlock;
import com.naterbobber.darkerdepths.block.generic.RelationalWallBlock;
import com.naterbobber.darkerdepths.block.generic.VerticalSlabBlock;
import com.naterbobber.darkerdepths.block.generic.WoodPostBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDItems;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class DDBlockStateProvider
extends BlockStateProvider {
    private final Set<Block> blockIgnores = new HashSet<Block>();

    public DDBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "darkerdepths", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.AMBER);
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.VOID_SOUL_REQUIEM);
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.GLOW_GRIME);
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.GLOWSHROOM_CAP);
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.FORSAKEN_BRONZE_SCRAP);
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.FORSAKEN_BRONZE_INGOT);
        this.add(this::woodBlockWithItem, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_WOOD, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_LOG);
        this.add(this::woodBlockWithItem, (DeferredHolder<Block, ? extends Block>)DDBlocks.STRIPPED_PETRIFIED_WOOD, (DeferredHolder<Block, ? extends Block>)DDBlocks.STRIPPED_PETRIFIED_LOG);
        this.add(this::columnBlockWithItem, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_BOOKSHELF, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_PLANKS);
        this.add(this::woodBlockWithItem, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_BOARDS, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_BOARDS);
        this.skip(new DeferredHolder[]{DDBlocks.VOID_SOUL_JAR, DDBlocks.DEATH_ANCHOR, DDBlocks.AMBER_CLUSTER, DDBlocks.DEATH_ANCHOR, DDBlocks.AMBER_CLUSTER, DDBlocks.ASH, DDBlocks.CRYSTAL_MELON, DDBlocks.DEAD_LIVING_CRYSTAL, DDBlocks.GEYSER, DDBlocks.GLOWSHROOM, DDBlocks.GLIMMERING_VINE_PLANT, DDBlocks.GLIMMERING_VINES, DDBlocks.GLOWSHROOM_HEART, DDBlocks.GLOWSPURS, DDBlocks.MAGMA_PAD, DDBlocks.PARANOIA_ALTAR, DDBlocks.PETRIFIED_ROOTS, DDBlocks.PETRIFIED_ROOTS_PLANT, DDBlocks.STONE_MELON, DDBlocks.TOMB, DDBlocks.SKULL_WALL, DDBlocks.POTTED_GLOWSHROOM, DDBlocks.ROPE, DDBlocks.VOID_SOUL_TORCH, DDBlocks.WALL_VOID_SOUL_TORCH, DDBlocks.GLOWSHROOM_LANTERN, DDBlocks.MOB_PLACER, DDBlocks.MOSSY_GRIMESTONE, DDBlocks.GLOWSHROOM_LAMP});
        this.autoGenerateBlockAssets();
    }

    @SafeVarargs
    private void skip(DeferredHolder<Block, ? extends Block> ... blockHolders) {
        Arrays.stream(blockHolders).forEach(blockHolder -> this.blockIgnores.add((Block)blockHolder.get()));
    }

    private void add(Consumer<DeferredHolder<Block, ? extends Block>> function, DeferredHolder<Block, ? extends Block> block) {
        this.blockIgnores.add((Block)block.get());
        function.accept(block);
    }

    private void add(BiConsumer<DeferredHolder<Block, ? extends Block>, DeferredHolder<Block, ? extends Block>> function, DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> parentBlock) {
        this.blockIgnores.add((Block)block.get());
        function.accept(block, parentBlock);
    }

    private void autoGenerateBlockAssets() {
        DDBlocks.BLOCKS.getEntries().stream().filter(holder -> !this.blockIgnores.contains(holder.get())).forEach(holder -> {
            Block block;
            Block block2 = block = (Block)holder.get();
            Objects.requireNonNull(block2);
            Block selector0$temp = block2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IRelationalBlock.class, DoorBlock.class, TrapDoorBlock.class, BushBlock.class, RotatedPillarBlock.class, ConnectedPillarBlock.class, SignBlock.class, VerticalSlabBlock.class, WoodPostBlock.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    IRelationalBlock b = (IRelationalBlock)selector0$temp;
                    this.relationalBlockWithItem((DeferredHolder<Block, ? extends Block>)holder);
                    break;
                }
                case 1: {
                    DoorBlock b = (DoorBlock)selector0$temp;
                    this.doorBlockWithItem((DeferredHolder<Block, ? extends Block>)holder);
                    break;
                }
                case 2: {
                    TrapDoorBlock b = (TrapDoorBlock)selector0$temp;
                    this.trapdoorBlockWithItem((DeferredHolder<Block, ? extends Block>)holder);
                    break;
                }
                case 3: {
                    BushBlock b = (BushBlock)selector0$temp;
                    this.crossBlockWithItem((DeferredHolder<Block, ? extends Block>)holder);
                    break;
                }
                case 4: {
                    RotatedPillarBlock b = (RotatedPillarBlock)selector0$temp;
                    this.rotatablePillarBlockWithItem((DeferredHolder<Block, ? extends Block>)holder);
                    break;
                }
                case 5: {
                    ConnectedPillarBlock b = (ConnectedPillarBlock)selector0$temp;
                    this.connectedPillarBlockWithItem((DeferredHolder<Block, ? extends Block>)holder);
                    break;
                }
                case 6: {
                    SignBlock b = (SignBlock)selector0$temp;
                    this.skip((DeferredHolder<Block, ? extends Block>)holder);
                    break;
                }
                case 7: {
                    VerticalSlabBlock b = (VerticalSlabBlock)selector0$temp;
                    this.skip((DeferredHolder<Block, ? extends Block>)holder);
                    break;
                }
                case 8: {
                    WoodPostBlock b = (WoodPostBlock)selector0$temp;
                    this.skip((DeferredHolder<Block, ? extends Block>)holder);
                    break;
                }
                default: {
                    this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)holder);
                }
            }
        });
    }

    private void relationalBlockWithItem(DeferredHolder<Block, ? extends Block> blockHolder) {
        IRelationalBlock block = (IRelationalBlock)blockHolder.get();
        Block parentBlock = block.getBaseBlock();
        IRelationalBlock iRelationalBlock = block;
        Objects.requireNonNull(iRelationalBlock);
        IRelationalBlock iRelationalBlock2 = iRelationalBlock;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RelationalSlabBlock.class, RelationalStairBlock.class, RelationalPressurePlateBlock.class, RelationalButtonBlock.class, RelationalFenceBlock.class, RelationalFenceGateBlock.class, RelationalWallBlock.class}, (Object)iRelationalBlock2, n)) {
            case 0: {
                RelationalSlabBlock b = (RelationalSlabBlock)iRelationalBlock2;
                this.slabBlockWithItem(blockHolder, parentBlock);
                break;
            }
            case 1: {
                RelationalStairBlock b = (RelationalStairBlock)iRelationalBlock2;
                this.stairsBlockWithItem(blockHolder, parentBlock);
                break;
            }
            case 2: {
                RelationalPressurePlateBlock b = (RelationalPressurePlateBlock)iRelationalBlock2;
                this.pressurePlateBlockWithItem(blockHolder, parentBlock);
                break;
            }
            case 3: {
                RelationalButtonBlock b = (RelationalButtonBlock)iRelationalBlock2;
                this.buttonBlockWithItem(blockHolder, parentBlock);
                break;
            }
            case 4: {
                RelationalFenceBlock b = (RelationalFenceBlock)iRelationalBlock2;
                this.fenceBlockWithItem(blockHolder, parentBlock);
                break;
            }
            case 5: {
                RelationalFenceGateBlock b = (RelationalFenceGateBlock)iRelationalBlock2;
                this.fenceGateBlockWithItem(blockHolder, parentBlock);
                break;
            }
            case 6: {
                RelationalWallBlock b = (RelationalWallBlock)iRelationalBlock2;
                this.wallBlockWithItem(blockHolder, parentBlock);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(block));
            }
        }
    }

    private void simpleItem(DeferredHolder<Item, ? extends Item> item) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(item.getId().getPath(), "item/generated")).texture("layer0", this.modLoc("item/" + item.getId().getPath()));
    }

    private void simpleBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        this.simpleBlock((Block)block.get());
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void logBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        this.logBlock((RotatedPillarBlock)block.get());
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void stairsBlockWithItem(DeferredHolder<Block, ? extends Block> block, Block parentTexture) {
        this.stairsBlock((StairBlock)block.get(), this.blockTexture(parentTexture));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void slabBlockWithItem(DeferredHolder<Block, ? extends Block> block, Block parentTexture) {
        this.slabBlock((SlabBlock)block.get(), this.blockTexture(parentTexture), this.blockTexture(parentTexture));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void wallBlockWithItem(DeferredHolder<Block, ? extends Block> block, Block parentTexture) {
        this.wallBlock((WallBlock)block.get(), this.blockTexture(parentTexture));
        this.itemModels().wallInventory(block.getId().getPath(), this.blockTexture(parentTexture));
    }

    private void fenceBlockWithItem(DeferredHolder<Block, ? extends Block> block, Block parentTexture) {
        this.fenceBlock((FenceBlock)block.get(), this.blockTexture(parentTexture));
        this.itemModels().fenceInventory(block.getId().getPath(), this.blockTexture(parentTexture));
    }

    private void fenceGateBlockWithItem(DeferredHolder<Block, ? extends Block> block, Block parentTexture) {
        this.fenceGateBlock((FenceGateBlock)block.get(), this.blockTexture(parentTexture));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void rotatablePillarBlockWithItem(DeferredHolder<Block, ? extends Block> blockHolder) {
        RotatedPillarBlock block = (RotatedPillarBlock)blockHolder.get();
        String blockName = block.getName().getString();
        if (blockName.contains("wood")) {
            return;
        }
        this.logBlockWithItem(blockHolder);
    }

    private void doorBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation location = block.getId();
        ResourceLocation bottomTexture = location.withPath("block/" + location.getPath() + "_bottom");
        ResourceLocation topTexture = location.withPath("block/" + location.getPath() + "_top");
        this.doorBlock((DoorBlock)block.get(), bottomTexture, topTexture);
        ResourceLocation itemTexture = location.withPath("item/" + location.getPath());
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().getPath(), "item/generated")).texture("layer0", itemTexture);
    }

    private void connectedPillarBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation location = block.getId();
        String blockName = location.getPath();
        ResourceLocation endTexture = location.withPath("block/" + blockName + "_end");
        ResourceLocation sideTexture = location.withPath("block/" + blockName + "_side");
        ResourceLocation sideLowerTexture = location.withPath("block/" + blockName + "_side_lower");
        ResourceLocation sideMiddleTexture = location.withPath("block/" + blockName + "_side_middle");
        ResourceLocation sideUpperTexture = location.withPath("block/" + blockName + "_side_upper");
        ModelBuilder defaultModel = this.models().cubeColumn(blockName + "_default", sideTexture, endTexture);
        ModelBuilder lowerModel = this.models().cubeColumn(blockName + "_lower", sideLowerTexture, endTexture);
        ModelBuilder middleModel = this.models().cubeColumn(blockName + "_middle", sideMiddleTexture, endTexture);
        ModelBuilder upperModel = this.models().cubeColumn(blockName + "_upper", sideUpperTexture, endTexture);
        this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> DDBlockStateProvider.lambda$connectedPillarBlockWithItem$3((ModelFile)lowerModel, (ModelFile)middleModel, (ModelFile)upperModel, (ModelFile)defaultModel, arg_0));
        this.simpleBlockItem((Block)block.get(), (ModelFile)defaultModel);
    }

    private void trapdoorBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation location = block.getId();
        String path = "block/" + location.getPath();
        this.trapdoorBlock((TrapDoorBlock)block.get(), this.modLoc(path), true);
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.modLoc(path + "_bottom")));
    }

    private void pressurePlateBlockWithItem(DeferredHolder<Block, ? extends Block> block, Block parentTexture) {
        this.pressurePlateBlock((PressurePlateBlock)block.get(), this.blockTexture(parentTexture));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void buttonBlockWithItem(DeferredHolder<Block, ? extends Block> block, Block parentTexture) {
        this.buttonBlock((ButtonBlock)block.get(), this.blockTexture(parentTexture));
        this.itemModels().buttonInventory(block.getId().getPath(), this.blockTexture(parentTexture));
    }

    private void woodBlockWithItem(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> logTextureSource) {
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)("block/" + logTextureSource.getId().getPath()));
        this.axisBlock((RotatedPillarBlock)block.get(), texture, texture);
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void crossBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().cross(block.getId().getPath(), this.blockTexture((Block)block.get()))).renderType("cutout"));
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().getPath(), "item/generated")).texture("layer0", this.blockTexture((Block)block.get()));
    }

    private void columnBlockWithItem(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> topBlock) {
        ResourceLocation location = block.getId();
        String blockName = location.getPath();
        ResourceLocation topLocation = topBlock.getId();
        String parentBlockName = topLocation.getPath();
        ResourceLocation sideTexture = location.withPath("block/" + blockName);
        ResourceLocation topTexture = location.withPath("block/" + parentBlockName);
        ModelBuilder cubeColumn = this.models().cubeColumn(blockName, sideTexture, topTexture);
        this.getVariantBuilder((Block)block.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)cubeColumn)});
        this.simpleBlockItem((Block)block.get(), (ModelFile)cubeColumn);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$connectedPillarBlockWithItem$3(ModelFile lowerModel, ModelFile middleModel, ModelFile upperModel, ModelFile defaultModel, BlockState state) {
        ConnectedPillarBlock.PillarState type = (ConnectedPillarBlock.PillarState)((Object)state.getValue(ConnectedPillarBlock.PILLAR_STATE));
        ModelFile modelToUse = switch (type) {
            case ConnectedPillarBlock.PillarState.LOWER -> lowerModel;
            case ConnectedPillarBlock.PillarState.MIDDLE -> middleModel;
            case ConnectedPillarBlock.PillarState.UPPER -> upperModel;
            default -> defaultModel;
        };
        return ConfiguredModel.builder().modelFile(modelToUse).build();
    }
}

