/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.entities.VoidSoulMonster;
import com.naterbobber.darkerdepths.entities.goals.AttackMemoryTargetGoal;
import com.naterbobber.darkerdepths.entities.goals.DashGoal;
import com.naterbobber.darkerdepths.entities.goals.IDashable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BodySnatcherEntity
extends VoidSoulMonster
implements GeoEntity,
IDashable {
    private int attackTick;
    private int damageDelay;
    private Entity attackTarget;
    private static final float REACH = 1.65f;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation ATTACK_ANIM = RawAnimation.begin().then("attack.swing", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    protected static final RawAnimation PRE_DASH = RawAnimation.begin().thenLoop("pre_dash");
    protected static final RawAnimation HURT = RawAnimation.begin().thenLoop("hurt");
    private static final EntityDataAccessor<Boolean> PREPARING_TO_DASH = SynchedEntityData.defineId(BodySnatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DASHING = SynchedEntityData.defineId(BodySnatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public BodySnatcherEntity(EntityType<? extends VoidSoulMonster> type, Level level) {
        super(type, level);
        this.xpReward = 10;
        this.setOrbHeight(0.35);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.275).add(Attributes.ATTACK_SPEED, 2.4).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.targetSelector.addGoal(4, new AttackMemoryTargetGoal<Player>((Mob)this, Player.class, 100, true));
        this.goalSelector.addGoal(1, (Goal)new DashGoal((Mob)this, 2.5, 0.2, 10.0, 15, 60, 5));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackTick > 0) {
            --this.attackTick;
            if (this.attackTick == 0) {
                this.setAttacking(false);
            }
        }
        if (this.damageDelay > 0) {
            --this.damageDelay;
        }
        if (this.attackTarget == null) {
            return;
        }
        if (!this.attackTarget.isAlive() || !this.isAlive()) {
            this.attackTarget = null;
            return;
        }
        if (this.damageDelay == 0) {
            if (this.distanceToSqr(this.attackTarget) < 4.0) {
                this.attackTarget.hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
            }
            this.attackTarget = null;
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (this.attackTick == 0) {
            this.setAttacking(true);
            this.attackTick = 20;
            this.damageDelay = 10;
            if (entity instanceof LivingEntity) {
                this.attackTarget = entity;
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
            return true;
        }
        return false;
    }

    protected AABB getAttackBoundingBox() {
        Entity entity = this.getVehicle();
        if (entity != null) {
            AABB aabb1 = entity.getBoundingBox();
            AABB aabb2 = this.getBoundingBox();
            return new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        }
        return this.getBoundingBox().inflate((double)1.65f, 0.0, (double)1.65f);
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walkingController", 5, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackingController", 0, this::attackPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "dashController", 0, this::dashPredicate));
    }

    protected <E extends BodySnatcherEntity> PlayState predicate(AnimationState<E> event) {
        return event.setAndContinue(IDLE_ANIM);
    }

    protected <E extends BodySnatcherEntity> PlayState dashPredicate(AnimationState<E> event) {
        if (this.isPreparingToDash()) {
            return event.setAndContinue(PRE_DASH);
        }
        event.getController().stop();
        return PlayState.STOP;
    }

    protected <E extends BodySnatcherEntity> PlayState attackPredicate(AnimationState<E> event) {
        if (this.isAttacking()) {
            if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                event.getController().forceAnimationReset();
                event.getController().setAnimation(ATTACK_ANIM);
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.VEX_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.VEX_HURT;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.VEX_AMBIENT;
    }

    protected void playStepSound(BlockPos pPos, BlockState pState) {
    }

    @Override
    public void setPreparingToDash(boolean isPreparing) {
        this.entityData.set(PREPARING_TO_DASH, (Object)isPreparing);
    }

    @Override
    public void setDashing(boolean isDashing) {
        this.entityData.set(DASHING, (Object)isDashing);
    }

    public boolean isPreparingToDash() {
        return (Boolean)this.entityData.get(PREPARING_TO_DASH);
    }

    public boolean isDashing() {
        return (Boolean)this.entityData.get(DASHING);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PREPARING_TO_DASH, (Object)false);
        builder.define(DASHING, (Object)false);
    }
}

