/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.entities.VoidSoulMonster;
import com.naterbobber.darkerdepths.entities.control.ConfigurableMoveControl;
import com.naterbobber.darkerdepths.entities.goals.AttackMemoryTargetGoal;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VoidSoulKnightEntity
extends VoidSoulMonster
implements GeoEntity {
    private int attackTick;
    private int firstDamageDelay;
    private int secondDamageDelay;
    private boolean firstAttackDone;
    private Entity attackTarget;
    private int dormantCheckCooldown = 0;
    private static final int PERSISTENCE = 600;
    private static final float REACH = 2.25f;
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("move.walk");
    protected static final RawAnimation ATTACK_ANIM = RawAnimation.begin().then("attack.swing", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    protected static final RawAnimation DORMANT_ANIM = RawAnimation.begin().thenLoop("dormant");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> IS_DORMANT = SynchedEntityData.defineId(VoidSoulKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public VoidSoulKnightEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.xpReward = 30;
        this.moveControl = new ConfigurableMoveControl((Mob)this, 10.0f);
        this.setOrbHeight(1.5);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, 0.17).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.85).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    protected void registerGoals() {
        if (!this.isDormant()) {
            this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.3, true));
            this.targetSelector.addGoal(3, new AttackMemoryTargetGoal<Player>((Mob)this, Player.class, 600, true));
            this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackTick > 0) {
            --this.attackTick;
            if (this.attackTick == 0) {
                this.setAttacking(false);
            }
        }
        if (this.firstDamageDelay > 0) {
            --this.firstDamageDelay;
        }
        if (this.secondDamageDelay > 0) {
            --this.secondDamageDelay;
        }
        if (this.attackTarget == null) {
            return;
        }
        if (!this.attackTarget.isAlive()) {
            this.attackTarget = null;
            return;
        }
        float damage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        if (this.firstDamageDelay == 0 && !this.firstAttackDone) {
            this.attackTarget.hurt(this.level().damageSources().mobAttack((LivingEntity)this), damage);
            this.firstAttackDone = true;
            return;
        }
        if (this.secondDamageDelay == 0) {
            if (this.distanceToSqr(this.attackTarget) < 12.0) {
                this.attackTarget.hurt(this.level().damageSources().mobAttack((LivingEntity)this), damage);
            }
            this.attackTarget = null;
        }
    }

    public void tick() {
        boolean hpChanged;
        boolean isPeaceful;
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (this.dormantCheckCooldown != 0) {
            --this.dormantCheckCooldown;
            return;
        }
        boolean bl = isPeaceful = this.level().getDifficulty() == Difficulty.PEACEFUL;
        if (!this.isDormant()) {
            if (isPeaceful) {
                this.setDormant(true);
            }
            return;
        }
        this.setYBodyRot(this.getYRot());
        this.setYHeadRot(this.getYRot());
        if (isPeaceful) {
            return;
        }
        Player player = this.level().getNearestPlayer((Entity)this, 8.0);
        boolean bl2 = hpChanged = this.getHealth() < this.getMaxHealth();
        if (player != null && !player.isCreative()) {
            this.awakeFromDormant();
            this.setTarget((LivingEntity)player);
            return;
        }
        if (hpChanged) {
            this.awakeFromDormant();
        }
    }

    private void awakeFromDormant() {
        this.setDormant(false);
        this.registerGoals();
        this.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, 0.4f);
        this.dormantCheckCooldown = 20;
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.5f);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public boolean doHurtTarget(Entity entity) {
        if (this.getAttackTick() == 0) {
            this.setAttacking(true);
            this.attackTick = 50;
            this.firstDamageDelay = 10;
            this.firstAttackDone = false;
            this.secondDamageDelay = 38;
            if (entity instanceof LivingEntity) {
                this.attackTarget = (LivingEntity)entity;
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
            return true;
        }
        return false;
    }

    protected AABB getAttackBoundingBox() {
        Entity entity = this.getVehicle();
        if (entity != null) {
            AABB aabb1 = entity.getBoundingBox();
            AABB aabb2 = this.getBoundingBox();
            return new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        }
        return this.getBoundingBox().inflate(2.25, 0.0, 2.25);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walkingController", 5, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackingController", 0, this::attackPredicate));
    }

    protected <E extends VoidSoulKnightEntity> PlayState predicate(AnimationState<E> event) {
        if (this.isDormant()) {
            return event.setAndContinue(DORMANT_ANIM);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALK_ANIM);
        }
        return event.setAndContinue(IDLE_ANIM);
    }

    protected <E extends VoidSoulKnightEntity> PlayState attackPredicate(AnimationState<E> event) {
        if (this.isAttacking()) {
            if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                event.getController().forceAnimationReset();
                event.getController().setAnimation(ATTACK_ANIM);
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_DORMANT, (Object)true);
    }

    public boolean isDormant() {
        return (Boolean)this.entityData.get(IS_DORMANT);
    }

    public void setDormant(boolean dormant) {
        this.entityData.set(IS_DORMANT, (Object)dormant);
        this.setNoAi(dormant);
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }
}

