/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.entities.VoidSoulEntity;
import com.naterbobber.darkerdepths.init.DDEntityTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public abstract class VoidSoulMonster
extends Monster {
    private double orbHeight = 0.0;
    private static final EntityDataAccessor<Boolean> IDLE = SynchedEntityData.defineId(VoidSoulMonster.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(VoidSoulMonster.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    protected VoidSoulMonster(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public double getOrbHeight() {
        return this.orbHeight;
    }

    public void setOrbHeight(double orbHeight) {
        this.orbHeight = orbHeight;
    }

    public void die(DamageSource pDamageSource) {
        if (!this.level().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            SimpleParticleType particle = ParticleTypes.LARGE_SMOKE;
            serverLevel.sendParticles((ParticleOptions)particle, this.getX(), this.getY(0.5), this.getZ(), 30, (double)this.getBbWidth() / 2.0, (double)this.getBbHeight() / 2.0, (double)this.getBbWidth() / 2.0, 0.05);
            VoidSoulEntity voidSoulEntity = (VoidSoulEntity)((EntityType)DDEntityTypes.VOID_SOUL.get()).create((Level)serverLevel);
            if (voidSoulEntity != null) {
                voidSoulEntity.moveTo(this.getX(), this.getY() + this.getOrbHeight(), this.getZ(), this.getYRot(), this.getXRot());
                voidSoulEntity.setExperienceDrop(this.xpReward);
                serverLevel.addFreshEntity((Entity)voidSoulEntity);
            }
        }
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    public boolean isIdle() {
        return (Boolean)this.entityData.get(IDLE);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public void setIdle(boolean idle) {
        this.entityData.set(IDLE, (Object)idle);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IDLE, (Object)false);
        builder.define(ATTACKING, (Object)false);
    }
}

