/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.events;

import com.naterbobber.darkerdepths.block.custom.CrystalMelonBlock;
import com.naterbobber.darkerdepths.component.SuperchargeInfo;
import com.naterbobber.darkerdepths.config.DDConfig;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDDataComponents;
import com.naterbobber.darkerdepths.util.SuperchargeHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="darkerdepths")
public class PlayerEvents {
    @SubscribeEvent
    public static void onApplySupercharge(PlayerInteractEvent.RightClickItem event) {
        boolean isEligible;
        Player player = event.getEntity();
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack mainHandStack = player.getMainHandItem();
        ItemStack offHandStack = player.getOffhandItem();
        boolean bl = isEligible = mainHandStack.isDamageableItem() || mainHandStack.has(DataComponents.UNBREAKABLE);
        if (offHandStack.is(((CrystalMelonBlock)((Object)DDBlocks.CRYSTAL_MELON.get())).asItem()) && isEligible && !(mainHandStack.getItem() instanceof ArmorItem) && !PlayerEvents.isSupercharged(mainHandStack, level)) {
            SuperchargeHelper.applyUpgrades(mainHandStack, level);
            offHandStack.shrink(1);
            level.playSound(null, player.blockPosition(), SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 0.75f, 1.6f);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        SuperchargeInfo info;
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        if (player == null || !PlayerEvents.isSupercharged(stack, player.level())) {
            return;
        }
        int digSpeedBuff = (Integer)DDConfig.CONFIG.SUPERCHARGE_DIG_SPEED.get();
        int attackSpeedBuff = (Integer)DDConfig.CONFIG.SUPERCHARGE_ATTACK_SPEED.get();
        int attackDamageBuff = (Integer)DDConfig.CONFIG.SUPERCHARGE_ATTACK_DAMAGE.get();
        event.getToolTip().add(Component.empty());
        event.getToolTip().add(Component.literal((String)"Supercharged:").withStyle(ChatFormatting.AQUA));
        event.getToolTip().add(Component.literal((String)(" +" + digSpeedBuff + "% Dig Speed")).withStyle(ChatFormatting.GRAY));
        event.getToolTip().add(Component.literal((String)(" +" + attackDamageBuff + "% Attack Damage")).withStyle(ChatFormatting.GRAY));
        event.getToolTip().add(Component.literal((String)(" +" + attackSpeedBuff + "% Attack Speed")).withStyle(ChatFormatting.GRAY));
        if (((Boolean)DDConfig.CONFIG.SUPERCHARGE_UNBREAKABLE.get()).booleanValue()) {
            event.getToolTip().add(Component.literal((String)"Unbreakable").withStyle(ChatFormatting.BLUE));
        }
        if ((info = (SuperchargeInfo)stack.get((DataComponentType)DDDataComponents.SUPERCHARGE_INFO.get())) == null) {
            return;
        }
        long expirationTick = info.expirationTick();
        long currentTime = player.level().getGameTime();
        long remainingTicks = expirationTick - currentTime;
        long remainingSeconds = remainingTicks / 20L;
        String timeFormatted = String.format("%02d:%02d", remainingSeconds / 60L, remainingSeconds % 60L);
        event.getToolTip().add(Component.literal((String)("Time Remaining: " + timeFormatted)).withStyle(ChatFormatting.DARK_GRAY));
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player;
        Player player2 = event.getEntity();
        if (player2 instanceof Player && (player2 = (player = player2).level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)player2;
            if (!level.isClientSide) {
                PlayerEvents.isSupercharged(player.getMainHandItem(), (Level)level);
                PlayerEvents.isSupercharged(player.getOffhandItem(), (Level)level);
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Level level;
        ItemStack heldItem = event.getEntity().getMainHandItem();
        if (PlayerEvents.isSupercharged(heldItem, level = event.getEntity().level())) {
            float currentSpeed = event.getNewSpeed();
            event.setNewSpeed(currentSpeed * (1.0f + (float)((Integer)DDConfig.CONFIG.SUPERCHARGE_DIG_SPEED.get()).intValue() / 100.0f));
        }
    }

    private static boolean isSupercharged(ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return false;
        }
        SuperchargeInfo info = (SuperchargeInfo)stack.get((DataComponentType)DDDataComponents.SUPERCHARGE_INFO.get());
        if (info == null) {
            return false;
        }
        if (level.getGameTime() >= info.expirationTick()) {
            SuperchargeHelper.revertUpgrades(stack);
            return false;
        }
        return true;
    }
}

