/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.init;

import com.mojang.datafixers.util.Pair;
import com.naterbobber.darkerdepths.util.DDResourceKeys;
import com.naterbobber.darkerdepths.util.DDTags;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DDStructures {
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"darkerdepths");

    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        HolderGetter poolGetter = context.lookup(Registries.TEMPLATE_POOL);
        Structure.StructureSettings forestSettings = new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(DDTags.Biomes.HAS_ROPE_MINE_FOREST), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE);
        context.register(DDResourceKeys.Structures.ROPE_MINE_FOREST, (Object)new JigsawStructure(forestSettings, (Holder)poolGetter.getOrThrow(DDResourceKeys.StructureTemplatePools.ROPE_MINE_FOREST_POOL), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-10)), true, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 80, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
        Structure.StructureSettings desertSettings = new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(DDTags.Biomes.HAS_ROPE_MINE_DESERT), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE);
        context.register(DDResourceKeys.Structures.ROPE_MINE_DESERT, (Object)new JigsawStructure(desertSettings, (Holder)poolGetter.getOrThrow(DDResourceKeys.StructureTemplatePools.ROPE_MINE_DESERT_POOL), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-18)), true, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 80, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
        Structure.StructureSettings catacombs = new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(DDTags.Biomes.CATACOMBS), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(v -> v, v1 -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create()))), GenerationStep.Decoration.VEGETAL_DECORATION, TerrainAdjustment.BURY);
        context.register(DDResourceKeys.Structures.CATACOMBS, (Object)new JigsawStructure(catacombs, (Holder)poolGetter.getOrThrow(DDResourceKeys.StructureTemplatePools.CATACOMBS_STARTS_POOL), Optional.empty(), 7, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-10)), false, Optional.empty(), 116, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
    }

    public static void bootstrapStructureSet(BootstrapContext<StructureSet> context) {
        HolderGetter structureGetter = context.lookup(Registries.STRUCTURE);
        context.register(DDResourceKeys.StructureSets.ROPE_MINE_FOREST_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(DDResourceKeys.Structures.ROPE_MINE_FOREST), (StructurePlacement)new RandomSpreadStructurePlacement(24, 8, RandomSpreadType.LINEAR, 1234567890)));
        context.register(DDResourceKeys.StructureSets.ROPE_MINE_DESERT_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(DDResourceKeys.Structures.ROPE_MINE_DESERT), (StructurePlacement)new RandomSpreadStructurePlacement(28, 10, RandomSpreadType.LINEAR, 1234567891)));
        context.register(DDResourceKeys.StructureSets.CATACOMBS_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(DDResourceKeys.Structures.CATACOMBS), (StructurePlacement)new RandomSpreadStructurePlacement(24, 8, RandomSpreadType.LINEAR, 20083232)));
    }

    public static void bootstrapTemplatePool(BootstrapContext<StructureTemplatePool> context) {
        Holder.Reference emptyPoolHolder = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
        HolderGetter processorList = context.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference catacombsProcessor = processorList.getOrThrow(DDResourceKeys.StructureProcessorLists.CATACOMBS_PROCESSOR);
        Holder.Reference ropeMineProcessor = processorList.getOrThrow(DDResourceKeys.StructureProcessorLists.ROPE_MINES_PROCESSOR);
        context.register(DDResourceKeys.StructureTemplatePools.ROPE_MINE_FOREST_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:rope_mine_forest", (Holder)ropeMineProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        context.register(DDResourceKeys.StructureTemplatePools.ROPE_MINE_DESERT_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:rope_mine_desert", (Holder)ropeMineProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        context.register(DDResourceKeys.StructureTemplatePools.CATACOMBS_STARTS_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/center_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/center_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        context.register(DDResourceKeys.StructureTemplatePools.CATACOMBS_CENTER_EXTENSIONS_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_5", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_6", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20))));
        context.register(DDResourceKeys.StructureTemplatePools.CATACOMBS_HALLS_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_5", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_6", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10))));
        context.register(DDResourceKeys.StructureTemplatePools.CATACOMBS_HALLS_EXTENSIONS, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_5", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_6", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_7", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_8", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/treasure_room_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/treasure_room_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/treasure_room_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20))));
    }
}

