/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.init;

import com.naterbobber.darkerdepths.entities.VoidSoulEntity;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDEntityTypes;
import com.naterbobber.darkerdepths.init.DDItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class DDVanillaIntegration {
    public static void init() {
        DDVanillaIntegration.registerFlammables();
        DDVanillaIntegration.registerCompostables();
        DDVanillaIntegration.registerDispenserBehaviors();
    }

    private static void registerFlammables() {
        FireBlock fireBlock = (FireBlock)Blocks.FIRE;
        fireBlock.setFlammable((Block)DDBlocks.ROPE.get(), 60, 100);
        fireBlock.setFlammable((Block)DDBlocks.PETRIFIED_ROOTS.get(), 60, 100);
        fireBlock.setFlammable((Block)DDBlocks.DRY_SPROUTS.get(), 60, 100);
        fireBlock.setFlammable((Block)DDBlocks.MOSSY_SPROUTS.get(), 60, 100);
    }

    private static void registerCompostables() {
    }

    private static void registerDispenserBehaviors() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)DDItems.VOID_SOUL_JAR.get()), (source, stack) -> {
            ServerLevel level = source.level();
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos pos = source.pos();
            VoidSoulEntity entity = new VoidSoulEntity((EntityType<? extends PathfinderMob>)((EntityType)DDEntityTypes.VOID_SOUL.get()), (Level)level);
            entity.setPos((double)pos.getX() + 0.5 + (double)direction.getStepX(), (double)pos.getY() + 0.5 + (double)direction.getStepY(), (double)pos.getZ() + 0.5 + (double)direction.getStepZ());
            level.addFreshEntity((Entity)entity);
            level.playSound(null, pos, SoundEvents.WITCH_DRINK, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.shrink(1);
            DispenserBlockEntity patt0$temp = source.blockEntity();
            if (patt0$temp instanceof DispenserBlockEntity) {
                int i;
                DispenserBlockEntity dispenser = patt0$temp;
                ItemStack bottleStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                boolean wasBottlePlaced = false;
                for (i = 0; i < dispenser.getContainerSize(); ++i) {
                    ItemStack slotStack = dispenser.getItem(i);
                    if (!slotStack.is(Items.GLASS_BOTTLE) || slotStack.getCount() >= slotStack.getMaxStackSize()) continue;
                    slotStack.grow(1);
                    wasBottlePlaced = true;
                    break;
                }
                if (!wasBottlePlaced) {
                    for (i = 0; i < dispenser.getContainerSize(); ++i) {
                        if (!dispenser.getItem(i).isEmpty()) continue;
                        dispenser.setItem(i, bottleStack);
                        wasBottlePlaced = true;
                        break;
                    }
                }
                if (!wasBottlePlaced) {
                    DefaultDispenseItemBehavior fallback = new DefaultDispenseItemBehavior();
                    fallback.dispense(source, bottleStack);
                }
            }
            return stack;
        });
    }
}

