/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.util;

import com.google.common.collect.Lists;
import com.naterbobber.darkerdepths.DarkerDepths;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class DDResourceKeys {

    public static class LootTables {
        public static final ResourceKey<LootTable> CATACOMBS_CHEST_STANDARD = LootTables.createKey("chests/catacombs/standard");
        public static final ResourceKey<LootTable> CATACOMBS_CHEST_TREASURE = LootTables.createKey("chests/catacombs/treasure");
        public static final ResourceKey<LootTable> CATACOMBS_ARCHAEOLOGY_STANDARD = LootTables.createKey("archaeology/catacombs/standard");

        private static ResourceKey<LootTable> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)DarkerDepths.id(name));
        }
    }

    public static class DamageTypes {
        public static final ResourceKey<DamageType> SOUL_BINDING_DAMAGE = DamageTypes.createKey("soul_binding_damage");

        private static ResourceKey<DamageType> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)DarkerDepths.id(name));
        }
    }

    public static class Enchantments {
        public static final List<ResourceKey<Enchantment>> ENCHANTMENTS = Lists.newArrayList();
        public static final ResourceKey<Enchantment> SWIFT_STRIKE = Enchantments.createKey("swift_strike");
        public static final ResourceKey<Enchantment> QUICK_DASH = Enchantments.createKey("quick_dash");

        private static ResourceKey<Enchantment> createKey(String name) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)DarkerDepths.id(name));
            ENCHANTMENTS.add((ResourceKey<Enchantment>)key);
            return key;
        }
    }

    public static class StructureProcessorLists {
        public static final ResourceKey<StructureProcessorList> CATACOMBS_PROCESSOR = StructureProcessorLists.createKey("catacombs_processor");
        public static final ResourceKey<StructureProcessorList> ROPE_MINES_PROCESSOR = StructureProcessorLists.createKey("rope_mines_processor");

        private static ResourceKey<StructureProcessorList> createKey(String pName) {
            return ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)DarkerDepths.id(pName));
        }
    }

    public static class StructureTemplatePools {
        public static final ResourceKey<StructureTemplatePool> ROPE_MINE_FOREST_POOL = StructureTemplatePools.createKey("rope_mine_forest");
        public static final ResourceKey<StructureTemplatePool> ROPE_MINE_DESERT_POOL = StructureTemplatePools.createKey("rope_mine_desert");
        public static final ResourceKey<StructureTemplatePool> CATACOMBS_STARTS_POOL = StructureTemplatePools.createKey("catacombs/starts");
        public static final ResourceKey<StructureTemplatePool> CATACOMBS_HALLS_POOL = StructureTemplatePools.createKey("catacombs/halls");
        public static final ResourceKey<StructureTemplatePool> CATACOMBS_CENTER_EXTENSIONS_POOL = StructureTemplatePools.createKey("catacombs/center_extensions");
        public static final ResourceKey<StructureTemplatePool> CATACOMBS_HALLS_EXTENSIONS = StructureTemplatePools.createKey("catacombs/extensions");

        private static ResourceKey<StructureTemplatePool> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)DarkerDepths.id(name));
        }
    }

    public static class StructureSets {
        public static final ResourceKey<StructureSet> ROPE_MINE_FOREST_SET = StructureSets.createKey("rope_mine_forest");
        public static final ResourceKey<StructureSet> ROPE_MINE_DESERT_SET = StructureSets.createKey("rope_mine_desert");
        public static final ResourceKey<StructureSet> CATACOMBS_SET = StructureSets.createKey("catacombs_set");

        private static ResourceKey<StructureSet> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)DarkerDepths.id(name));
        }
    }

    public static class Structures {
        public static final ResourceKey<Structure> ROPE_MINE_FOREST = Structures.createKey("rope_mine_forest");
        public static final ResourceKey<Structure> ROPE_MINE_DESERT = Structures.createKey("rope_mine_desert");
        public static final ResourceKey<Structure> CATACOMBS = Structures.createKey("catacombs");

        private static ResourceKey<Structure> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)DarkerDepths.id(name));
        }
    }

    public static class PlacedFeatures {
        public static final ResourceKey<PlacedFeature> HUGE_GLOWSHROOM = PlacedFeatures.createKey("huge_glowshroom");
        public static final ResourceKey<PlacedFeature> GLOWSHROOM_PATCH = PlacedFeatures.createKey("glowshroom_patch");
        public static final ResourceKey<PlacedFeature> AMBER_PLACEMENT = PlacedFeatures.createKey("amber");
        public static final ResourceKey<PlacedFeature> MOLTEN_SPRING = PlacedFeatures.createKey("molten_spring");
        public static final ResourceKey<PlacedFeature> MOLTEN_POOL = PlacedFeatures.createKey("molten_pool");
        public static final ResourceKey<PlacedFeature> DARKSLATE_PLACEMENT = PlacedFeatures.createKey("darkslate_placement");
        public static final ResourceKey<PlacedFeature> CATACOMBS_SAND_PLACEMENT = PlacedFeatures.createKey("catacombs_sand_placement");
        public static final ResourceKey<PlacedFeature> CATACOMBS_LAYERED_PLACEMENT = PlacedFeatures.createKey("catacombs_layered_placement");
        public static final ResourceKey<PlacedFeature> PETRIFIED_BRANCH = PlacedFeatures.createKey("petrified_branch");
        public static final ResourceKey<PlacedFeature> MAGMA_ORE = PlacedFeatures.createKey("magma_ore");
        public static final ResourceKey<PlacedFeature> GRIME_SURFACE = PlacedFeatures.createKey("grime_surface");
        public static final ResourceKey<PlacedFeature> ARID_SURFACE = PlacedFeatures.createKey("arid_surface");
        public static final ResourceKey<PlacedFeature> DARKSLATE_SURFACE = PlacedFeatures.createKey("darkslate_surface");
        public static final ResourceKey<PlacedFeature> ARID_BOULDER = PlacedFeatures.createKey("arid_boulder");
        public static final ResourceKey<PlacedFeature> CATACOMBS_LAVA_LINING = PlacedFeatures.createKey("catacombs_lava_lining");
        public static final ResourceKey<PlacedFeature> DUSKROCK_STRIPE = PlacedFeatures.createKey("duskrock_stripe");
        public static final ResourceKey<PlacedFeature> GLIMMERING_VINES = PlacedFeatures.createKey("glimmering_vines");
        public static final ResourceKey<PlacedFeature> DEAD_LIVING_CRYSTAL_ORE = PlacedFeatures.createKey("dead_living_crystal_ore");
        public static final ResourceKey<PlacedFeature> DUSKROCK_ORE = PlacedFeatures.createKey("duskrock_ore");

        public static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)DarkerDepths.id(name));
        }
    }

    public static class ConfiguredFeatures {
        public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWSHROOM_PATCH = ConfiguredFeatures.createKey("glowshroom_patch");
        public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_GLOWSHROOM = ConfiguredFeatures.createKey("huge_glowshroom");
        public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_GLOWSHROOM_PLANTED = ConfiguredFeatures.createKey("huge_glowshroom_planted");
        public static final ResourceKey<ConfiguredFeature<?, ?>> AMBERS_PLACEMENT = ConfiguredFeatures.createKey("amber_placement");
        public static final ResourceKey<ConfiguredFeature<?, ?>> MOLTEN_SPRING = ConfiguredFeatures.createKey("molten_spring");
        public static final ResourceKey<ConfiguredFeature<?, ?>> ASH_PLACEMENTS = ConfiguredFeatures.createKey("ash_placement");
        public static final ResourceKey<ConfiguredFeature<?, ?>> GEYSER_PLACEMENT = ConfiguredFeatures.createKey("geyser_placement");
        public static final ResourceKey<ConfiguredFeature<?, ?>> MOLTEN_POOL = ConfiguredFeatures.createKey("molten_pool");
        public static final ResourceKey<ConfiguredFeature<?, ?>> GRIME_VEGETATION = ConfiguredFeatures.createKey("grime_vegetation");
        public static final ResourceKey<ConfiguredFeature<?, ?>> ARID_VEGETATION = ConfiguredFeatures.createKey("arid_vegetation");
        public static final ResourceKey<ConfiguredFeature<?, ?>> DARKSLATE_VEGETATION = ConfiguredFeatures.createKey("darkslate_vegetation");
        public static final ResourceKey<ConfiguredFeature<?, ?>> DARKSLATE_PLACEMENT = ConfiguredFeatures.createKey("darkslate_placement");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CATACOMBS_SAND_PLACEMENT = ConfiguredFeatures.createKey("catacombs_sand_placement");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CATACOMBS_LAYERED_PLACEMENT = ConfiguredFeatures.createKey("catacombs_layer_placement");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SHORT_PETRIFIED_BRANCH = ConfiguredFeatures.createKey("short_petrified_branch");
        public static final ResourceKey<ConfiguredFeature<?, ?>> LONG_PETRIFIED_BRANCH = ConfiguredFeatures.createKey("long_petrified_branch");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PETRIFIED_BRANCH = ConfiguredFeatures.createKey("petrified_branch");
        public static final ResourceKey<ConfiguredFeature<?, ?>> MAGMA_ORE = ConfiguredFeatures.createKey("magma_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> DARKSLATE_SURFACE = ConfiguredFeatures.createKey("darkslate_surface");
        public static final ResourceKey<ConfiguredFeature<?, ?>> ARID_SURFACE = ConfiguredFeatures.createKey("arid_surface");
        public static final ResourceKey<ConfiguredFeature<?, ?>> GRIME_SURFACE = ConfiguredFeatures.createKey("grime_surface");
        public static final ResourceKey<ConfiguredFeature<?, ?>> ARID_BOULDER = ConfiguredFeatures.createKey("arid_boulder");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CATACOMBS_LAVA_LINING = ConfiguredFeatures.createKey("catacombs_lava_lining");
        public static final ResourceKey<ConfiguredFeature<?, ?>> DUSKROCK_STRIPE = ConfiguredFeatures.createKey("duskrock_stripe");
        public static final ResourceKey<ConfiguredFeature<?, ?>> GLIMMERING_VINES = ConfiguredFeatures.createKey("glimmering_vines");
        public static final ResourceKey<ConfiguredFeature<?, ?>> DEAD_LIVING_CRYSTAL_ORE = ConfiguredFeatures.createKey("dead_living_crystal_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> DUSKROCK_ORE = ConfiguredFeatures.createKey("duskrock_ore");

        public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)DarkerDepths.id(name));
        }
    }

    public static class BiomeModifiers {
        public static final ResourceKey<BiomeModifier> ADD_MOLTEN_CAVERNS_VEGETAL_FEATURES = BiomeModifiers.createKey("add_molten_caverns_vegetal_features");
        public static final ResourceKey<BiomeModifier> ADD_MOLTEN_CAVERNS_ORES = BiomeModifiers.createKey("add_molten_caverns_ores");
        public static final ResourceKey<BiomeModifier> ADD_SANDY_CATACOMBS_LOCAL_MODIFICATIONS = BiomeModifiers.createKey("add_sandy_catacombs_local_modifications");
        public static final ResourceKey<BiomeModifier> ADD_SANDY_CATACOMBS_VEGETAL_FEATURES = BiomeModifiers.createKey("add_sandy_catacombs_vegetal_features");
        public static final ResourceKey<BiomeModifier> ADD_SANDY_CATACOMBS_SPAWNS = BiomeModifiers.createKey("add_sandy_catacombs_spawns");
        public static final ResourceKey<BiomeModifier> ADD_SANDY_CATACOMBS_RAW_GENERATION = BiomeModifiers.createKey("add_sandy_catacombs_raw_generation");
        public static final ResourceKey<BiomeModifier> ADD_SANDY_CATACOMBS_UNDERGROUND_DECORATION = BiomeModifiers.createKey("add_sandy_catacombs_underground_decoration");
        public static final ResourceKey<BiomeModifier> ADD_GLOWSHROOM_FOREST_VEGETAL_FEATURES = BiomeModifiers.createKey("add_glowshroom_forest_vegetal_features");
        public static final ResourceKey<BiomeModifier> ADD_GLOWSHROOM_FOREST_SPAWNS = BiomeModifiers.createKey("add_glowshroom_forest_spawns");

        private static ResourceKey<BiomeModifier> createKey(String name) {
            return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)DarkerDepths.id(name));
        }
    }

    public static class Biomes {
        public static final List<ResourceKey<Biome>> BIOMES = Lists.newArrayList();
        public static final ResourceKey<Biome> MOLTEN_CAVERN = Biomes.createKey("molten_cavern");
        public static final ResourceKey<Biome> SANDY_CATACOMBS = Biomes.createKey("sandy_catacombs");
        public static final ResourceKey<Biome> GLOWSHROOM_FOREST = Biomes.createKey("glowshroom_forest");

        public static ResourceKey<Biome> createKey(String name) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)DarkerDepths.id(name));
            BIOMES.add((ResourceKey<Biome>)key);
            return key;
        }
    }
}

