/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.util;

import com.naterbobber.darkerdepths.DarkerDepths;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class DDTags {
    private static <T> TagKey<T> createTag(ResourceKey<Registry<T>> registry, String id) {
        return TagKey.create(registry, (ResourceLocation)DarkerDepths.id(id));
    }

    private static <T> TagKey<T> createCompatTag(ResourceKey<Registry<T>> registry, String id, String compatID) {
        return TagKey.create(registry, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)compatID, (String)id));
    }

    public static class Biomes {
        private static final ResourceKey<Registry<Biome>> RK = Registries.BIOME;
        public static final TagKey<Biome> HAS_ROPE_MINE_FOREST = DDTags.createTag(RK, "has_structure/rope_mine_forest");
        public static final TagKey<Biome> HAS_ROPE_MINE_DESERT = DDTags.createTag(RK, "has_structure/rope_mine_desert");
        public static final TagKey<Biome> CATACOMBS = DDTags.createTag(RK, "has_structure/catacombs");
    }

    public static class Blocks {
        private static final ResourceKey<Registry<Block>> RK = Registries.BLOCK;
        public static final TagKey<Block> GEYSER_BOOSTERS = DDTags.createTag(RK, "geyser_boosters");
        public static final TagKey<Block> GEYSER_BYPASSES = DDTags.createTag(RK, "geyser_bypasses");
        public static final TagKey<Block> HUSKS_SPAWNABLE_ON = DDTags.createTag(RK, "husks_spawnable_on");
        public static final TagKey<Block> TRIMMED_PLANKS = DDTags.createCompatTag(RK, "trimmed_planks", "nomansland");
        public static final TagKey<Block> WOODEN_BOOKSHELVES = DDTags.createCompatTag(RK, "wooden_bookshelves", "blueprint");
        public static final TagKey<Block> WOODEN_BOARDS = DDTags.createCompatTag(RK, "wooden_boards", "woodworks");
    }

    public static class Items {
        private static final ResourceKey<Registry<Item>> RK = Registries.ITEM;
        public static final TagKey<Item> PETRIFIED_LOGS = DDTags.createTag(RK, "petrified_logs");
        public static final TagKey<Item> STILETTO_ENCHANTABLE = DDTags.createTag(RK, "stiletto_enchantable");
    }
}

