/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.worldgen;

import com.mojang.datafixers.util.Pair;
import com.naterbobber.darkerdepths.config.DDBiomeConfig;
import com.naterbobber.darkerdepths.util.DDResourceKeys;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;

public class BiomeReagentHandler {
    private static final DDBiomeConfig.Defaults SANDY_CATACOMBS_DEFAULTS = new DDBiomeConfig.Defaults(0.5, 1.2, -1.0, -0.4, 0.1, 0.3, -0.25, 1.0, -1.0, 1.0, 0.3, 2.0, 0.0);
    private static final DDBiomeConfig.Defaults GLOWSHROOM_FOREST_DEFAULTS = new DDBiomeConfig.Defaults(0.4, 1.0, 0.6, 1.2, -0.5, 0.5, 0.1, 0.5, -1.0, 1.0, 0.3, 0.9, 0.0);
    private static final DDBiomeConfig.Defaults MOLTEN_CAVERN_DEFAULTS = new DDBiomeConfig.Defaults(-0.75, 0.75, -1.0, 1.0, 0.65, 0.8, -0.325, 0.0, -1.0, 1.0, 0.8, 2.0, 0.0);

    public static void init(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
        consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)BiomeReagentHandler.climateParamsFromConfig(SANDY_CATACOMBS_DEFAULTS), DDResourceKeys.Biomes.SANDY_CATACOMBS));
        consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)BiomeReagentHandler.climateParamsFromConfig(GLOWSHROOM_FOREST_DEFAULTS), DDResourceKeys.Biomes.GLOWSHROOM_FOREST));
        consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)BiomeReagentHandler.climateParamsFromConfig(MOLTEN_CAVERN_DEFAULTS), DDResourceKeys.Biomes.MOLTEN_CAVERN));
    }

    private static Climate.ParameterPoint climateParamsFromConfig(DDBiomeConfig config) {
        return Climate.parameters((Climate.Parameter)Climate.Parameter.span((float)((Double)config.tempMin().get()).floatValue(), (float)((Double)config.tempMax().get()).floatValue()), (Climate.Parameter)Climate.Parameter.span((float)((Double)config.humidityMin().get()).floatValue(), (float)((Double)config.humidityMax().get()).floatValue()), (Climate.Parameter)Climate.Parameter.span((float)((Double)config.continentalnessMin().get()).floatValue(), (float)((Double)config.continentalnessMax().get()).floatValue()), (Climate.Parameter)Climate.Parameter.span((float)((Double)config.erosionMin().get()).floatValue(), (float)((Double)config.erosionMax().get()).floatValue()), (Climate.Parameter)Climate.Parameter.span((float)((Double)config.depthMin().get()).floatValue(), (float)((Double)config.depthMax().get()).floatValue()), (Climate.Parameter)Climate.Parameter.span((float)((Double)config.weirdnessMin().get()).floatValue(), (float)((Double)config.weirdnessMax().get()).floatValue()), (float)((Double)config.offset().get()).floatValue());
    }

    private static Climate.ParameterPoint climateParamsFromConfig(DDBiomeConfig.Defaults config) {
        return Climate.parameters((Climate.Parameter)Climate.Parameter.span((float)((float)config.tempMin()), (float)((float)config.tempMax())), (Climate.Parameter)Climate.Parameter.span((float)((float)config.humidityMin()), (float)((float)config.humidityMax())), (Climate.Parameter)Climate.Parameter.span((float)((float)config.continentalnessMin()), (float)((float)config.continentalnessMax())), (Climate.Parameter)Climate.Parameter.span((float)((float)config.erosionMin()), (float)((float)config.erosionMax())), (Climate.Parameter)Climate.Parameter.span((float)((float)config.depthMin()), (float)((float)config.depthMax())), (Climate.Parameter)Climate.Parameter.span((float)((float)config.weirdnessMin()), (float)((float)config.weirdnessMax())), (float)((float)config.offset()));
    }
}

