/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.worldgen;

import com.naterbobber.darkerdepths.init.DDEntityTypes;
import com.naterbobber.darkerdepths.util.DDResourceKeys;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import org.jetbrains.annotations.NotNull;

public class DDBiomeModifiers {
    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        context.register(DDResourceKeys.BiomeModifiers.ADD_MOLTEN_CAVERNS_VEGETAL_FEATURES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDResourceKeys.Biomes.MOLTEN_CAVERN), DDBiomeModifiers.getPlacedFeature(context, DDResourceKeys.PlacedFeatures.DARKSLATE_PLACEMENT, DDResourceKeys.PlacedFeatures.AMBER_PLACEMENT, DDResourceKeys.PlacedFeatures.MOLTEN_POOL, DDResourceKeys.PlacedFeatures.MOLTEN_SPRING), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(DDResourceKeys.BiomeModifiers.ADD_MOLTEN_CAVERNS_ORES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDResourceKeys.Biomes.MOLTEN_CAVERN), DDBiomeModifiers.getPlacedFeature(context, DDResourceKeys.PlacedFeatures.MAGMA_ORE, DDResourceKeys.PlacedFeatures.DEAD_LIVING_CRYSTAL_ORE), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(DDResourceKeys.BiomeModifiers.ADD_SANDY_CATACOMBS_LOCAL_MODIFICATIONS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDResourceKeys.Biomes.SANDY_CATACOMBS), DDBiomeModifiers.getPlacedFeature(context, new ResourceKey[0]), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
        context.register(DDResourceKeys.BiomeModifiers.ADD_SANDY_CATACOMBS_VEGETAL_FEATURES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDResourceKeys.Biomes.SANDY_CATACOMBS), DDBiomeModifiers.getPlacedFeature(context, DDResourceKeys.PlacedFeatures.PETRIFIED_BRANCH, DDResourceKeys.PlacedFeatures.ARID_SURFACE), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(DDResourceKeys.BiomeModifiers.ADD_SANDY_CATACOMBS_SPAWNS, (Object)new BiomeModifiers.AddSpawnsBiomeModifier(DDBiomeModifiers.getBiome(context, DDResourceKeys.Biomes.SANDY_CATACOMBS), List.of(new MobSpawnSettings.SpawnerData(EntityType.CAVE_SPIDER, 80, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 50, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.ENDERMAN, 10, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.HUSK, 95, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)DDEntityTypes.BODY_SNATCHER.get(), 30, 1, 3))));
        context.register(DDResourceKeys.BiomeModifiers.ADD_SANDY_CATACOMBS_RAW_GENERATION, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDResourceKeys.Biomes.SANDY_CATACOMBS), DDBiomeModifiers.getPlacedFeature(context, DDResourceKeys.PlacedFeatures.ARID_BOULDER, DDResourceKeys.PlacedFeatures.DUSKROCK_ORE), GenerationStep.Decoration.RAW_GENERATION));
        context.register(DDResourceKeys.BiomeModifiers.ADD_SANDY_CATACOMBS_UNDERGROUND_DECORATION, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDResourceKeys.Biomes.SANDY_CATACOMBS), DDBiomeModifiers.getPlacedFeature(context, DDResourceKeys.PlacedFeatures.CATACOMBS_LAVA_LINING), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        context.register(DDResourceKeys.BiomeModifiers.ADD_GLOWSHROOM_FOREST_VEGETAL_FEATURES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDResourceKeys.Biomes.GLOWSHROOM_FOREST), DDBiomeModifiers.getPlacedFeature(context, DDResourceKeys.PlacedFeatures.GLIMMERING_VINES, DDResourceKeys.PlacedFeatures.HUGE_GLOWSHROOM, DDResourceKeys.PlacedFeatures.GRIME_SURFACE), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(DDResourceKeys.BiomeModifiers.ADD_GLOWSHROOM_FOREST_SPAWNS, (Object)new BiomeModifiers.AddSpawnsBiomeModifier(DDBiomeModifiers.getBiome(context, DDResourceKeys.Biomes.GLOWSHROOM_FOREST), List.of(new MobSpawnSettings.SpawnerData((EntityType)DDEntityTypes.GLOWSHROOM_MONSTER.get(), 200, 1, 2))));
    }

    @SafeVarargs
    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstrapContext<BiomeModifier> context, ResourceKey<PlacedFeature> ... placedFeature) {
        return HolderSet.direct(Stream.of(placedFeature).map(resourceKey -> context.lookup(Registries.PLACED_FEATURE).getOrThrow(resourceKey)).collect(Collectors.toList()));
    }

    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstrapContext<BiomeModifier> context, ResourceKey<PlacedFeature> placedFeature) {
        return HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(placedFeature)});
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull HolderSet.Direct<Biome> getBiome(BootstrapContext<BiomeModifier> bootstapContext, ResourceKey<Biome> biome) {
        return HolderSet.direct((Holder[])new Holder[]{bootstapContext.lookup(Registries.BIOME).getOrThrow(biome)});
    }
}

