/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ConnectedPillarBlock
extends Block {
    public static final EnumProperty<PillarState> PILLAR_STATE = EnumProperty.m_61587_((String)"pillar_state", PillarState.class);

    public ConnectedPillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PILLAR_STATE, (Comparable)((Object)PillarState.DEFAULT)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getState((LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.UP || pDirection == Direction.DOWN) {
            return this.getState(pLevel, pCurrentPos);
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    private BlockState getState(LevelAccessor level, BlockPos pos) {
        boolean isPillarBelow;
        Block blockAbove = level.m_8055_(pos.m_7494_()).m_60734_();
        Block blockBelow = level.m_8055_(pos.m_7495_()).m_60734_();
        boolean isPillarAbove = blockAbove == this;
        boolean bl = isPillarBelow = blockBelow == this;
        PillarState currentState = isPillarAbove && isPillarBelow ? PillarState.MIDDLE : (isPillarAbove ? PillarState.LOWER : (isPillarBelow ? PillarState.UPPER : PillarState.DEFAULT));
        return (BlockState)this.m_49966_().m_61124_(PILLAR_STATE, (Comparable)((Object)currentState));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{PILLAR_STATE});
    }

    public static enum PillarState implements StringRepresentable
    {
        DEFAULT("default"),
        LOWER("lower"),
        MIDDLE("middle"),
        UPPER("upper");

        private final String name;

        private PillarState(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

