/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.m_61587_((String)"type", VerticalSlabType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public VerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        rot = rot.m_55952_(Rotation.CLOCKWISE_180);
        return state.m_61143_(TYPE) == VerticalSlabType.DOUBLE ? state : (BlockState)state.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(rot.m_55954_(((VerticalSlabType)((Object)state.m_61143_(VerticalSlabBlock.TYPE))).direction))));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_61143_(TYPE) == VerticalSlabType.DOUBLE ? state : (BlockState)state.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(((VerticalSlabType)((Object)state.m_61143_(VerticalSlabBlock.TYPE))).direction.m_122424_())));
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((VerticalSlabType)((Object)state.m_61143_(VerticalSlabBlock.TYPE))).shape;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = context.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60734_() == this) {
            return (BlockState)((BlockState)blockstate.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluid = context.m_43725_().m_6425_(blockpos);
        BlockState retState = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        Direction direction = this.getDirectionForPlacement(context);
        VerticalSlabType type = VerticalSlabType.fromDirection(direction);
        return (BlockState)retState.m_61124_(TYPE, (Comparable)((Object)type));
    }

    private Direction getDirectionForPlacement(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        if (direction.m_122434_() != Direction.Axis.Y) {
            return direction;
        }
        BlockPos pos = context.m_8083_();
        Vec3 vec = context.m_43720_().m_82546_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_82492_(0.5, 0.0, 0.5);
        double angle = Math.atan2(vec.f_82479_, vec.f_82481_) * -180.0 / Math.PI;
        return Direction.m_122364_((double)angle).m_122424_();
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        VerticalSlabType slabType = (VerticalSlabType)((Object)state.m_61143_(TYPE));
        return slabType != VerticalSlabType.DOUBLE && stack.m_41720_() == this.m_5456_() && (context.m_7058_() && context.m_43719_() == slabType.direction && this.getDirectionForPlacement(context) == slabType.direction || !context.m_7058_() && context.m_43719_().m_122434_() != slabType.direction.m_122434_());
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull FluidState fluidStateIn) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE && super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE && super.m_6044_(worldIn, pos, state, fluidIn);
    }

    public BlockState m_7417_(BlockState stateIn, Direction p_60542_, BlockState p_60543_, LevelAccessor worldIn, BlockPos currentPos, BlockPos p_60546_) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, p_60542_, p_60543_, worldIn, currentPos, p_60546_);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    public static enum VerticalSlabType implements StringRepresentable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        private final String name;
        public final Direction direction;
        public final VoxelShape shape;

        private VerticalSlabType(Direction direction) {
            this.name = direction == null ? "double" : direction.m_122433_();
            this.direction = direction;
            if (direction == null) {
                this.shape = Shapes.m_83144_();
            } else {
                double min = 0.0;
                double max = 8.0;
                if (direction.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                    min = 8.0;
                    max = 16.0;
                }
                this.shape = direction.m_122434_() == Direction.Axis.X ? Block.m_49796_((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0) : Block.m_49796_((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
            }
        }

        public String toString() {
            return this.name;
        }

        public static VerticalSlabType fromDirection(Direction direction) {
            for (VerticalSlabType type : VerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

