/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks.blockentities;

import com.naterbobber.darkerdepths.blocks.GeyserBlock;
import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import com.naterbobber.darkerdepths.init.DDBlockTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GeyserBlockEntity
extends BlockEntity {
    public GeyserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DDBlockEntityTypes.GEYSER.get(), pos, state);
    }

    public static void geyserTick(Level world, BlockPos pos, BlockState state, GeyserBlockEntity geyserBlockEntity) {
        if (world.m_5776_()) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)GeyserBlock.FACING);
        double boostSpeed = 0.06;
        double booster = (world.m_8055_(pos.m_121945_(direction.m_122424_())).m_204336_(DDBlockTags.GEYSER_BOOSTERS) ? boostSpeed * 2.0 : boostSpeed) * (double)direction.m_122421_().m_122540_();
        for (int i = 1; i < 7; ++i) {
            BlockPos relativePosition = pos.m_5484_(direction, i);
            BlockState relativeState = world.m_8055_(relativePosition);
            if (!world.m_7433_(relativePosition, DripstoneUtils::m_159666_)) {
                if (!relativeState.m_204343_().anyMatch(arg_0 -> DDBlockTags.GEYSER_BYPASSES.equals(arg_0)) && (!relativeState.m_61138_((Property)BlockStateProperties.f_61417_) || (Integer)relativeState.m_61143_((Property)BlockStateProperties.f_61417_) != 1)) break;
            }
            List nearbyEntities = world.m_45976_(Entity.class, new AABB(relativePosition));
            for (Entity entity : nearbyEntities) {
                Vec3 motion = entity.m_20184_();
                double xBooster = direction.m_122434_() == Direction.Axis.X ? booster : 0.0;
                double yBooster = direction.m_122434_() == Direction.Axis.Y ? booster : 0.0;
                double zBooster = direction.m_122434_() == Direction.Axis.Z ? booster : 0.0;
                entity.m_20334_(motion.f_82479_ + xBooster, motion.f_82480_ + yBooster, motion.f_82481_ + zBooster);
                entity.f_19789_ = 0.0f;
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
            }
        }
    }
}

