/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks.blockentities;

import com.naterbobber.darkerdepths.blocks.TombBlock;
import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.RenderUtils;

public class TombBlockEntity
extends BlockEntity
implements GeoBlockEntity,
Container {
    private static final int OPEN_ANIMATION_DURATION = 53;
    private static final int CLOSE_ANIMATION_DURATION = 40;
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private boolean isOpen = false;
    private boolean isAnimating = false;
    private int animationTimer = 0;

    public TombBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DDBlockEntityTypes.TOMB.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isOpen = nbt.m_128471_("IsOpen");
        this.isAnimating = nbt.m_128471_("IsAnimating");
        this.animationTimer = nbt.m_128451_("AnimationTimer");
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("IsOpen", this.isOpen);
        nbt.m_128379_("IsAnimating", this.isAnimating);
        nbt.m_128405_("AnimationTimer", this.animationTimer);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return ((ItemStack)this.items.get(0)).m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        return slot == 0 ? (ItemStack)this.items.get(0) : ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        if (slot == 0) {
            ItemStack result = (ItemStack)this.items.get(0);
            this.items.set(0, (Object)ItemStack.f_41583_);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot == 0) {
            this.items.set(0, (Object)stack);
            if (stack.m_41613_() > this.m_6893_()) {
                stack.m_41764_(this.m_6893_());
            }
            this.m_6596_();
            this.syncToClients();
        }
    }

    public ItemStack m_7407_(int slot, int amount) {
        if (slot == 0 && !((ItemStack)this.items.get(0)).m_41619_()) {
            ItemStack result = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
            if (!result.m_41619_()) {
                this.m_6596_();
                this.syncToClients();
            }
            return result;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6542_(Player player) {
        return this.isOpen && this.isInhabited() && this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public ItemStack getStoredItem() {
        return this.m_8020_(0);
    }

    public boolean hasStoredItem() {
        return !this.getStoredItem().m_41619_();
    }

    public boolean canTakeItem() {
        return this.isOpen && this.isInhabited() && this.hasStoredItem();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TombBlockEntity entity) {
        if (level.m_5776_()) {
            return;
        }
        if (entity.isAnimating) {
            int maxTicks;
            ++entity.animationTimer;
            int n = maxTicks = entity.isOpen ? 53 : 40;
            if (entity.animationTimer >= maxTicks) {
                entity.finishAnimation();
            }
        }
    }

    public void toggleTomb() {
        if (this.isAnimating) {
            return;
        }
        this.isOpen = !this.isOpen;
        this.startAnimation();
        this.playSound();
        this.syncToClients();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }

    public boolean isInhabited() {
        return (Boolean)this.m_58900_().m_61143_((Property)TombBlock.INHABITED);
    }

    private void startAnimation() {
        this.isAnimating = true;
        this.animationTimer = 0;
        this.m_6596_();
    }

    private void finishAnimation() {
        this.isAnimating = false;
        this.animationTimer = 0;
        this.m_6596_();
        this.syncToClients();
    }

    private void playSound() {
        if (this.f_58857_ != null) {
            if (this.isOpen) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, 0.4f);
            } else {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, 0.7f);
            }
        }
    }

    private void syncToClients() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animationPredicate)});
    }

    private PlayState animationPredicate(AnimationState<TombBlockEntity> state) {
        if (this.isAnimating) {
            String animationName = this.isOpen ? "open" : "close";
            state.getController().setAnimation(RawAnimation.begin().then(animationName, Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else if (this.isOpen) {
            state.getController().setAnimation(RawAnimation.begin().then("idle_open", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58900_();
        if (state.m_60734_() instanceof TombBlock) {
            Direction facing = (Direction)state.m_61143_((Property)TombBlock.FACING);
            return switch (facing) {
                case Direction.SOUTH -> new AABB(pos.m_7918_(-2, -8, -1), pos.m_7918_(3, 3, 8));
                case Direction.EAST -> new AABB(pos.m_7918_(-1, -8, -2), pos.m_7918_(8, 3, 3));
                case Direction.WEST -> new AABB(pos.m_7918_(-7, -8, -2), pos.m_7918_(2, 3, 3));
                default -> new AABB(pos.m_7918_(-2, -8, -7), pos.m_7918_(3, 3, 2));
            };
        }
        return super.getRenderBoundingBox();
    }
}

