/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.data.assets;

import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class DDBlockStateProvider
extends BlockStateProvider {
    public DDBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "darkerdepths", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleItem(DDItems.AMBER);
        this.simpleItem(DDItems.VOID_SOUL_REQUIEM);
        this.simpleItem(DDItems.GLOW_GRIME);
        this.simpleItem(DDItems.GLOWSHROOM_CAP);
        this.simpleItem(DDItems.FORSAKEN_BRONZE_SCRAP);
        this.simpleItem(DDItems.FORSAKEN_BRONZE_INGOT);
        this.simpleBlockWithItem(DDBlocks.AMBER_BLOCK);
        this.logBlockWithItem(DDBlocks.ARID_DEEPSLATE);
        this.simpleBlockWithItem(DDBlocks.GLOWSHROOM_BLOCK);
        this.logBlockWithItem(DDBlocks.GLOWSHROOM_STEM);
        this.simpleBlockWithItem(DDBlocks.LIVING_CRYSTAL);
        this.logBlockWithItem(DDBlocks.POROUS_PETRIFIED_LOG);
        this.simpleBlockWithItem(DDBlocks.ASH_BLOCK);
        this.simpleBlockWithItem(DDBlocks.FORSAKEN_BRONZE_BLOCK);
        this.simpleBlock((Block)DDBlocks.MOB_PLACER.get());
        this.crossBlockWithItem(DDBlocks.MOSSY_SPROUTS);
        this.crossBlockWithItem(DDBlocks.DRY_SPROUTS);
        this.logBlockSet(DDBlocks.ARIDROCK, DDBlocks.ARIDROCK_STAIRS, DDBlocks.ARIDROCK_SLAB, DDBlocks.ARIDROCK_WALL);
        this.simpleBlockSet(DDBlocks.POLISHED_ARIDROCK, DDBlocks.POLISHED_ARIDROCK_STAIRS, DDBlocks.POLISHED_ARIDROCK_SLAB);
        this.simpleBlockSet(DDBlocks.ARIDROCK_BRICKS, DDBlocks.ARIDROCK_BRICKS_STAIRS, DDBlocks.ARIDROCK_BRICKS_SLAB, DDBlocks.ARIDROCK_BRICKS_WALL);
        this.simpleBlockWithItem(DDBlocks.CHISELED_ARIDROCK_BRICKS);
        this.simpleBlockWithItem(DDBlocks.CRACKED_ARIDROCK_BRICKS);
        this.simpleBlockSet(DDBlocks.DUSKROCK, DDBlocks.DUSKROCK_STAIRS, DDBlocks.DUSKROCK_SLAB, DDBlocks.DUSKROCK_WALL);
        this.simpleBlockSet(DDBlocks.POLISHED_DUSKROCK, DDBlocks.POLISHED_DUSKROCK_STAIRS, DDBlocks.POLISHED_DUSKROCK_SLAB);
        this.simpleBlockSet(DDBlocks.DUSKROCK_BRICKS, DDBlocks.DUSKROCK_BRICKS_STAIRS, DDBlocks.DUSKROCK_BRICKS_SLAB, DDBlocks.DUSKROCK_BRICKS_WALL);
        this.simpleBlockWithItem(DDBlocks.CHISELED_DUSKROCK_BRICKS);
        this.simpleBlockWithItem(DDBlocks.CRACKED_DUSKROCK_BRICKS);
        this.logBlockSet(DDBlocks.GRIMESTONE, DDBlocks.GRIMESTONE_STAIRS, DDBlocks.GRIMESTONE_SLAB, DDBlocks.GRIMESTONE_WALL);
        this.simpleBlockSet(DDBlocks.POLISHED_GRIMESTONE, DDBlocks.POLISHED_GRIMESTONE_STAIRS, DDBlocks.POLISHED_GRIMESTONE_SLAB);
        this.simpleBlockSet(DDBlocks.GRIMESTONE_BRICKS, DDBlocks.GRIMESTONE_BRICKS_STAIRS, DDBlocks.GRIMESTONE_BRICKS_SLAB, DDBlocks.GRIMESTONE_BRICKS_WALL);
        this.simpleBlockWithItem(DDBlocks.CHISELED_GRIMESTONE_BRICKS);
        this.simpleBlockWithItem(DDBlocks.CRACKED_GRIMESTONE_BRICKS);
        this.logBlockSet(DDBlocks.DARKSLATE, DDBlocks.DARKSLATE_STAIRS, DDBlocks.DARKSLATE_SLAB, DDBlocks.DARKSLATE_WALL);
        this.simpleBlockSet(DDBlocks.POLISHED_DARKSLATE, DDBlocks.POLISHED_DARKSLATE_STAIRS, DDBlocks.POLISHED_DARKSLATE_SLAB);
        this.simpleBlockSet(DDBlocks.DARKSLATE_BRICKS, DDBlocks.DARKSLATE_BRICKS_STAIRS, DDBlocks.DARKSLATE_BRICKS_SLAB, DDBlocks.DARKSLATE_BRICKS_WALL);
        this.simpleBlockWithItem(DDBlocks.CHISELED_DARKSLATE_BRICKS);
        this.simpleBlockWithItem(DDBlocks.CRACKED_DARKSLATE_BRICKS);
        this.simpleWoodTypeSet(DDBlocks.PETRIFIED_PLANKS, DDBlocks.PETRIFIED_STAIRS, DDBlocks.PETRIFIED_SLAB, DDBlocks.PETRIFIED_FENCE, DDBlocks.PETRIFIED_FENCE_GATE, DDBlocks.PETRIFIED_DOOR, DDBlocks.PETRIFIED_TRAPDOOR, DDBlocks.PETRIFIED_PRESSURE_PLATE, DDBlocks.PETRIFIED_BUTTON, DDBlocks.PETRIFIED_LOG, DDBlocks.PETRIFIED_WOOD, DDBlocks.STRIPPED_PETRIFIED_LOG, DDBlocks.STRIPPED_PETRIFIED_WOOD);
    }

    private void simpleItem(RegistryObject<Item> item) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(item.getId().m_135815_(), "item/generated")).texture("layer0", this.modLoc("item/" + item.getId().m_135815_()));
    }

    private void simpleBlockWithItem(RegistryObject<Block> block) {
        this.simpleBlock((Block)block.get());
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void logBlockWithItem(RegistryObject<Block> block) {
        this.logBlock((RotatedPillarBlock)block.get());
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void stairsBlockWithItem(RegistryObject<Block> block, RegistryObject<Block> parentTexture) {
        this.stairsBlock((StairBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void slabBlockWithItem(RegistryObject<Block> block, RegistryObject<Block> parentTexture) {
        this.slabBlock((SlabBlock)block.get(), this.blockTexture((Block)parentTexture.get()), this.blockTexture((Block)parentTexture.get()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void wallBlockWithItem(RegistryObject<Block> block, RegistryObject<Block> parentTexture) {
        this.wallBlock((WallBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.itemModels().wallInventory(block.getId().m_135815_(), this.blockTexture((Block)parentTexture.get()));
    }

    private void fenceBlockWithItem(RegistryObject<Block> block, RegistryObject<Block> parentTexture) {
        this.fenceBlock((FenceBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.itemModels().fenceInventory(block.getId().m_135815_(), this.blockTexture((Block)parentTexture.get()));
    }

    private void fenceGateBlockWithItem(RegistryObject<Block> block, RegistryObject<Block> parentTexture) {
        this.fenceGateBlock((FenceGateBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void doorBlockWithItem(RegistryObject<Block> block) {
        ResourceLocation location = block.getId();
        ResourceLocation bottomTexture = location.m_247449_("block/" + location.m_135815_() + "_bottom");
        ResourceLocation topTexture = location.m_247449_("block/" + location.m_135815_() + "_top");
        this.doorBlock((DoorBlock)block.get(), bottomTexture, topTexture);
        ResourceLocation itemTexture = location.m_247449_("item/" + location.m_135815_());
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().m_135815_(), "item/generated")).texture("layer0", itemTexture);
    }

    private void trapdoorBlockWithItem(RegistryObject<Block> block) {
        ResourceLocation location = block.getId();
        String path = "block/" + location.m_135815_();
        this.trapdoorBlock((TrapDoorBlock)block.get(), this.modLoc(path), true);
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.modLoc(path + "_bottom")));
    }

    private void pressurePlateBlockWithItem(RegistryObject<Block> block, RegistryObject<Block> parentTexture) {
        this.pressurePlateBlock((PressurePlateBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void buttonBlockWithItem(RegistryObject<Block> block, RegistryObject<Block> parentTexture) {
        this.buttonBlock((ButtonBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.itemModels().buttonInventory(block.getId().m_135815_(), this.blockTexture((Block)parentTexture.get()));
    }

    private void woodBlockWithItem(RegistryObject<Block> block, RegistryObject<Block> logTextureSource) {
        ResourceLocation texture = new ResourceLocation("darkerdepths", "block/" + logTextureSource.getId().m_135815_());
        this.axisBlock((RotatedPillarBlock)block.get(), texture, texture);
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void crossBlockWithItem(RegistryObject<Block> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().cross(block.getId().m_135815_(), this.blockTexture((Block)block.get()))).renderType("cutout"));
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().m_135815_(), "item/generated")).texture("layer0", this.blockTexture((Block)block.get()));
    }

    private void simpleBlockSet(RegistryObject<Block> baseBlock, RegistryObject<Block> stairsBlock, RegistryObject<Block> slabBlock, RegistryObject<Block> wallBlock) {
        this.simpleBlockWithItem(baseBlock);
        this.stairsBlockWithItem(stairsBlock, baseBlock);
        this.slabBlockWithItem(slabBlock, baseBlock);
        this.wallBlockWithItem(wallBlock, baseBlock);
    }

    private void simpleBlockSet(RegistryObject<Block> baseBlock, RegistryObject<Block> stairsBlock, RegistryObject<Block> slabBlock) {
        this.simpleBlockWithItem(baseBlock);
        this.stairsBlockWithItem(stairsBlock, baseBlock);
        this.slabBlockWithItem(slabBlock, baseBlock);
    }

    private void logBlockSet(RegistryObject<Block> baseBlock, RegistryObject<Block> stairsBlock, RegistryObject<Block> slabBlock, RegistryObject<Block> wallBlock) {
        this.logBlockWithItem(baseBlock);
        this.stairsBlockWithItem(stairsBlock, baseBlock);
        this.slabBlockWithItem(slabBlock, baseBlock);
        this.wallBlockWithItem(wallBlock, baseBlock);
    }

    private void simpleWoodTypeSet(RegistryObject<Block> plankBlock, RegistryObject<Block> stairsBlock, RegistryObject<Block> slabBlock, RegistryObject<Block> fenceBlock, RegistryObject<Block> fenceGateBlock, RegistryObject<Block> doorBlock, RegistryObject<Block> trapdoorBlock, RegistryObject<Block> pressurePlateBlock, RegistryObject<Block> buttonBlock, RegistryObject<Block> logBlock, RegistryObject<Block> woodBlock, RegistryObject<Block> strippedLogBlock, RegistryObject<Block> strippedWoodBlock) {
        this.simpleBlockWithItem(plankBlock);
        this.stairsBlockWithItem(stairsBlock, plankBlock);
        this.slabBlockWithItem(slabBlock, plankBlock);
        this.fenceBlockWithItem(fenceBlock, plankBlock);
        this.fenceGateBlockWithItem(fenceGateBlock, plankBlock);
        this.doorBlockWithItem(doorBlock);
        this.trapdoorBlockWithItem(trapdoorBlock);
        this.pressurePlateBlockWithItem(pressurePlateBlock, plankBlock);
        this.buttonBlockWithItem(buttonBlock, plankBlock);
        this.logBlockWithItem(logBlock);
        this.woodBlockWithItem(woodBlock, logBlock);
        this.logBlockWithItem(strippedLogBlock);
        this.woodBlockWithItem(strippedWoodBlock, strippedLogBlock);
    }
}

