/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.entities.VoidSoulEntity;
import com.naterbobber.darkerdepths.entities.control.ConfigurableMoveControl;
import com.naterbobber.darkerdepths.entities.goals.AttackMemoryTargetGoal;
import com.naterbobber.darkerdepths.entities.goals.ConfigurableReachMeleeAttackGoal;
import com.naterbobber.darkerdepths.init.DDSoundEvents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GlowshroomMonsterEntity
extends Monster
implements GeoEntity {
    private int damageDelay;
    private Entity attackTarget;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation ATTACK_SLAM = RawAnimation.begin().then("attack.slam", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    protected static final RawAnimation ROAR = RawAnimation.begin().thenLoop("roar");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(GlowshroomMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(GlowshroomMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GlowshroomMonsterEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.f_21364_ = 20;
        this.f_21342_ = new ConfigurableMoveControl((Mob)this, 12.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ConfigurableReachMeleeAttackGoal((PathfinderMob)this, 2.0, true, 4.0f));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 2.0, 32.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, new AttackMemoryTargetGoal<Player>((Mob)this, Player.class, 300, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, false, false, entity -> !(entity instanceof Creeper) && !(entity instanceof GlowshroomMonsterEntity) && !(entity instanceof Bat) && !(entity instanceof VoidSoulEntity)));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAttackTick() > 0) {
            this.setAttackTick(this.getAttackTick() - 1);
            if (this.getAttackTick() == 0) {
                this.setAttacking(false);
            }
        }
        if (this.damageDelay > 0) {
            --this.damageDelay;
        }
        if (this.attackTarget == null) {
            return;
        }
        if (!this.attackTarget.m_6084_() || !this.m_6084_()) {
            this.attackTarget = null;
            return;
        }
        if (this.damageDelay == 0) {
            if (this.m_20280_(this.attackTarget) < 16.0) {
                this.attackTarget.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.5f);
            }
            this.attackTarget = null;
        }
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.m_5496_(SoundEvents.f_12357_, 1.0f, 1.5f);
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAttackTick() == 0) {
            this.setAttacking(true);
            this.setAttackTick(50);
            this.damageDelay = 24;
            if (entity instanceof LivingEntity) {
                this.attackTarget = entity;
            }
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            return true;
        }
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)DDSoundEvents.ENTITY_GLOWSHROOM_MONSTER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DDSoundEvents.ENTITY_GLOWSHROOM_MONSTER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)DDSoundEvents.ENTITY_GLOWSHROOM_MONSTER_HURT.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walkingController", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackingController", 0, this::attackPredicate)});
    }

    protected <E extends GlowshroomMonsterEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            return event.setAndContinue(WALK);
        }
        return event.setAndContinue(IDLE);
    }

    protected <E extends GlowshroomMonsterEntity> PlayState attackPredicate(AnimationState<E> event) {
        if (this.isAttacking()) {
            if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                event.getController().forceAnimationReset();
                event.getController().setAnimation(ATTACK_SLAM);
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TICK, (Object)0);
    }

    public int getAttackTick() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICK);
    }

    public void setAttackTick(int attackTick) {
        this.f_19804_.m_135381_(ATTACK_TICK, (Object)attackTick);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }
}

