/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.entities.VoidSoulKnightEntity;
import com.naterbobber.darkerdepths.entities.goals.ConfigurableRandomFlyingGoal;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VoidSoulEntity
extends PathfinderMob
implements GeoEntity {
    private boolean isCaptured = false;
    private int lifetime = 1200;
    private int experienceDrop = 12;
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> EXPIRES = SynchedEntityData.m_135353_(VoidSoulKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public VoidSoulEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_20242_(true);
        this.m_21530_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22280_, (double)0.35f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.2, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new ConfigurableRandomFlyingGoal(this, 1.0, 10));
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.expires()) {
            if (this.lifetime > 0) {
                --this.lifetime;
            } else {
                this.m_6074_();
            }
        }
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (itemStack.m_150930_(Items.f_42590_)) {
            this.isCaptured = true;
            this.m_6074_();
            this.m_216990_(SoundEvents.f_11771_);
            ItemStack voidSoulJarStack = new ItemStack((ItemLike)DDBlocks.VOID_SOUL_JAR.get());
            if (!pPlayer.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            if (itemStack.m_41619_()) {
                pPlayer.m_21008_(pHand, voidSoulJarStack);
            } else if (!pPlayer.m_150109_().m_36054_(voidSoulJarStack)) {
                pPlayer.m_36176_(voidSoulJarStack, false);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (itemStack.m_150930_((Item)DDItems.AMBER.get()) && this.expires()) {
            this.setExpires(false);
            this.m_216990_(SoundEvents.f_276532_);
            if (!this.m_9236_().m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)this.m_9236_();
                SimpleParticleType particle = ParticleTypes.f_175828_;
                serverLevel.m_8767_((ParticleOptions)particle, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 7, (double)this.m_20205_() / 2.0, (double)this.m_20206_() / 2.0, (double)this.m_20205_() / 2.0, 0.05);
            }
            if (!pPlayer.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_6667_(DamageSource pDamageSource) {
        if (!this.m_9236_().m_5776_()) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            if (!this.isCaptured) {
                SimpleParticleType particle = ParticleTypes.f_123755_;
                serverLevel.m_8767_((ParticleOptions)particle, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 30, (double)this.m_20205_() / 2.0, (double)this.m_20206_() / 2.0, (double)this.m_20205_() / 2.0, 0.05);
                if (this.experienceDrop > 0) {
                    this.m_21226_();
                }
            } else {
                SimpleParticleType particle = ParticleTypes.f_123762_;
                serverLevel.m_8767_((ParticleOptions)particle, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 5, (double)this.m_20205_() / 3.0, (double)this.m_20206_() / 3.0, (double)this.m_20205_() / 3.0, 0.05);
            }
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(pSource, pAmount);
        }
        return false;
    }

    public void m_269138_(DamageSource pDamageSource) {
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_21226_() {
        ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20182_(), (int)this.experienceDrop);
    }

    public void setExperienceDrop(int amount) {
        this.experienceDrop = amount;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("expires", this.expires());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("expires")) {
            this.setExpires(compound.m_128471_("expires"));
        }
        this.m_8099_();
    }

    public boolean expires() {
        return (Boolean)this.f_19804_.m_135370_(EXPIRES);
    }

    public void setExpires(boolean expires) {
        this.f_19804_.m_135381_(EXPIRES, (Object)expires);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EXPIRES, (Object)true);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walkingController", 5, this::predicate)});
    }

    protected <E extends VoidSoulEntity> PlayState predicate(AnimationState<E> event) {
        return event.setAndContinue(IDLE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_271165_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_215671_;
    }
}

