/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.events;

import com.naterbobber.darkerdepths.init.DDItems;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="darkerdepths")
public class RequiemCurseRemovalHandler {
    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack leftStack = event.getLeft();
        ItemStack rightStack = event.getRight();
        if (leftStack.m_41619_() || !rightStack.m_150930_((Item)DDItems.VOID_SOUL_REQUIEM.get())) {
            return;
        }
        if (!RequiemCurseRemovalHandler.hasCurse(leftStack)) {
            return;
        }
        int cost = 25;
        ItemStack output = leftStack.m_41777_();
        RequiemCurseRemovalHandler.removeCurses(output);
        event.setOutput(output);
        event.setCost(25);
        event.setMaterialCost(1);
    }

    private static void removeCurses(ItemStack stack) {
        if (!RequiemCurseRemovalHandler.hasCurse(stack)) {
            return;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        Map<Enchantment, Integer> nonCursedEnchantments = enchantments.entrySet().stream().filter(entry -> !((Enchantment)entry.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.m_44865_(nonCursedEnchantments, (ItemStack)stack);
    }

    private static boolean hasCurse(ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41793_()) {
            return false;
        }
        return EnchantmentHelper.m_44831_((ItemStack)stack).keySet().stream().anyMatch(Enchantment::m_6589_);
    }
}

