/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.init;

import com.google.common.collect.Lists;
import com.naterbobber.darkerdepths.DarkerDepths;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class DDBiomes {
    public static final List<ResourceKey<Biome>> BIOMES = Lists.newArrayList();
    public static final ResourceKey<Biome> MOLTEN_CAVERN = DDBiomes.createKey("molten_cavern");
    public static final ResourceKey<Biome> SANDY_CATACOMBS = DDBiomes.createKey("sandy_catacombs");
    public static final ResourceKey<Biome> GLOWSHROOM_FOREST = DDBiomes.createKey("glowshroom_forest");

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter holdergetter = context.m_255420_(Registries.f_256988_);
        HolderGetter holdergetter1 = context.m_255420_(Registries.f_257003_);
        context.m_255272_(MOLTEN_CAVERN, (Object)DDBiomes.createMoltenCavern((HolderGetter<PlacedFeature>)holdergetter, holdergetter1));
        context.m_255272_(SANDY_CATACOMBS, (Object)DDBiomes.createSandyCatacombs((HolderGetter<PlacedFeature>)holdergetter, holdergetter1));
        context.m_255272_(GLOWSHROOM_FOREST, (Object)DDBiomes.createGlowshroomForest((HolderGetter<PlacedFeature>)holdergetter, holdergetter1));
    }

    public static ResourceKey<Biome> createKey(String name) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)DarkerDepths.id(name));
        BIOMES.add((ResourceKey<Biome>)key);
        return key;
    }

    public static Biome createGlowshroomForest(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter1) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter1);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.m_263184_((Holder)SoundEvents.f_184219_);
        return DDBiomes.biome(true, 0.5f, 0.5f, mobBuilder, biomeBuilder, music);
    }

    public static Biome createMoltenCavern(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter1) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter1);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.m_263184_((Holder)SoundEvents.f_184219_);
        return DDBiomes.biome(true, 0.5f, 0.5f, mobBuilder, biomeBuilder, music);
    }

    public static Biome createSandyCatacombs(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter1) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter1);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195243_);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.m_263184_((Holder)SoundEvents.f_184219_);
        return DDBiomes.biome(true, 0.5f, 0.5f, 4169409, 341062, 11976546, mobBuilder, biomeBuilder, music);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, MobSpawnSettings.Builder mobBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return DDBiomes.biome(precipitation, temperature, downfall, 4159204, 329011, 5478752, mobBuilder, biomeBuilder, music);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int grassColor, MobSpawnSettings.Builder builder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48045_(grassColor).m_48040_(DDBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(builder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    protected static int calculateSkyColor(float temperature) {
        float $$1 = temperature / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }
}

