/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.item;

import com.naterbobber.darkerdepths.init.DDEnchantments;
import com.naterbobber.darkerdepths.init.DDItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class StilettoItem
extends SwordItem {
    public static final StilettoTier STILETTO = new StilettoTier();
    public static final String TIME_FRAME = "TimeFrame";
    public static final String READY_TICKS = "ReadyTicks";

    public StilettoItem(int damage, float speed, Item.Properties properties) {
        super((Tier)STILETTO, damage, speed, properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_21255_() || player.m_6047_()) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        itemStack.m_41622_(2, (LivingEntity)player, e -> e.m_21190_(hand));
        double dash = 1.85;
        player.m_246865_(player.m_20154_().m_82542_(1.0, 1.5, 1.0).m_82541_().m_82542_(dash, dash / 2.0, dash));
        player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
        int quickDash = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)DDEnchantments.QUICK_DASH.get()), (ItemStack)itemStack);
        int cooldown = 200;
        int reducedCooldown = (int)((float)cooldown * (1.0f - 0.25f * (float)quickDash));
        if (!player.m_36335_().m_41519_(itemStack.m_41720_())) {
            player.m_36335_().m_41524_(itemStack.m_41720_(), reducedCooldown);
        }
        itemStack.m_41784_().m_128405_(TIME_FRAME, 20);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int index, boolean selected) {
        Player player;
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            int readyTicks;
            int timeframe = tag.m_128451_(TIME_FRAME);
            if (timeframe > 0) {
                tag.m_128405_(TIME_FRAME, timeframe - 1);
            }
            if ((readyTicks = tag.m_128451_(READY_TICKS)) > 0) {
                tag.m_128405_(READY_TICKS, readyTicks - 1);
            }
        }
        if (entity instanceof Player && (player = (Player)entity).m_36335_().m_41521_((Item)this, 0.0f) == 0.1f) {
            itemStack.m_41784_().m_128405_(READY_TICKS, 10);
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.darkerdepths.press_shift").m_130940_(ChatFormatting.GRAY));
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.darkerdepths.stiletto.shift_desc").m_130940_(ChatFormatting.YELLOW));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (toolAction == ToolActions.SWORD_SWEEP) {
            return false;
        }
        return super.canPerformAction(stack, toolAction);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44983_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public static class StilettoTier
    implements Tier {
        public int m_6609_() {
            return 400;
        }

        public float m_6624_() {
            return 0.0f;
        }

        public float m_6631_() {
            return 2.0f;
        }

        public int m_6604_() {
            return 2;
        }

        public int m_6601_() {
            return 10;
        }

        public Ingredient m_6282_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DDItems.FORSAKEN_BRONZE_SCRAP.get()});
        }
    }
}

