/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.util;

import com.mojang.datafixers.util.Pair;
import com.naterbobber.darkerdepths.DarkerDepths;
import com.naterbobber.darkerdepths.config.DDBiomeConfig;
import com.naterbobber.darkerdepths.config.DDConfigs;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;

public class BiomeReagentHandler {
    public static final ResourceKey<Biome> MOLTEN_CAVERN = BiomeReagentHandler.register("molten_cavern");
    public static final ResourceKey<Biome> SANDY_CATACOMBS = BiomeReagentHandler.register("sandy_catacombs");
    public static final ResourceKey<Biome> GLOWSHROOM_FOREST = BiomeReagentHandler.register("glowshroom_forest");

    public static void init(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
        consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)BiomeReagentHandler.climateParamsFromConfig(DDConfigs.SANDY_CATACOMBS_CLIMATE), SANDY_CATACOMBS));
        consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)BiomeReagentHandler.climateParamsFromConfig(DDConfigs.GLOWSHROOM_FOREST_CLIMATE), GLOWSHROOM_FOREST));
        consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)BiomeReagentHandler.climateParamsFromConfig(DDConfigs.MOLTEN_CAVERN_CLIMATE), MOLTEN_CAVERN));
    }

    private static Climate.ParameterPoint climateParamsFromConfig(DDBiomeConfig config) {
        return Climate.m_186798_((Climate.Parameter)Climate.Parameter.m_186822_((float)((Double)config.tempMin().get()).floatValue(), (float)((Double)config.tempMax().get()).floatValue()), (Climate.Parameter)Climate.Parameter.m_186822_((float)((Double)config.humidityMin().get()).floatValue(), (float)((Double)config.humidityMax().get()).floatValue()), (Climate.Parameter)Climate.Parameter.m_186822_((float)((Double)config.continentalnessMin().get()).floatValue(), (float)((Double)config.continentalnessMax().get()).floatValue()), (Climate.Parameter)Climate.Parameter.m_186822_((float)((Double)config.erosionMin().get()).floatValue(), (float)((Double)config.erosionMax().get()).floatValue()), (Climate.Parameter)Climate.Parameter.m_186822_((float)((Double)config.depthMin().get()).floatValue(), (float)((Double)config.depthMax().get()).floatValue()), (Climate.Parameter)Climate.Parameter.m_186822_((float)((Double)config.weirdnessMin().get()).floatValue(), (float)((Double)config.weirdnessMax().get()).floatValue()), (float)((Double)config.offset().get()).floatValue());
    }

    private static ResourceKey<Biome> register(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)DarkerDepths.id(name));
    }
}

