/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.util;

import com.google.common.collect.Multimap;
import com.naterbobber.darkerdepths.config.DDConfigs;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SuperchargeHelper {
    public static final String TAG_UPGRADE_MAIN = "darkerdepths_upgrades";
    public static final String TAG_WAS_UNBREAKABLE = "was_unbreakable";
    public static final String TAG_HAD_MODIFIERS = "had_modifiers";
    public static final String TAG_EXPIRATION = "expiration_tick";
    public static final String TAG_MINING_BOOST = "mining_boost";
    public static final String TAG_SPEED_BOOST_LEVEL = "speed_boost_level";
    public static final String TAG_DAMAGE_BOOST_LEVEL = "damage_boost_level";
    public static final String TAG_ATTACK_SPEED_BOOST_LEVEL = "attack_speed_boost_level";
    private static final UUID ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("f8b8e0a8-f8a0-449e-917b-88a3a2dff83e");
    private static final UUID ATTACK_SPEED_MODIFIER_UUID = UUID.fromString("a7a7a3b8-1b0f-4859-866c-844a49e5e79f");

    public static void applyUpgrades(ItemStack tool, Level level) {
        boolean hadExistingModifiers;
        int superchargeMinutes = (Integer)DDConfigs.SUPERCHARGE_MINUTES.get();
        int digSpeedBuff = (Integer)DDConfigs.SUPERCHARGE_DIG_SPEED.get();
        int attackSpeedBuff = (Integer)DDConfigs.SUPERCHARGE_ATTACK_SPEED.get();
        int attackDamageBuff = (Integer)DDConfigs.SUPERCHARGE_ATTACK_DAMAGE.get();
        if (tool.m_41619_() || level.f_46443_) {
            return;
        }
        boolean wasAlreadyUnbreakable = tool.m_41782_() && tool.m_41783_().m_128471_("Unbreakable");
        boolean bl = hadExistingModifiers = tool.m_41782_() && tool.m_41783_().m_128425_("AttributeModifiers", 9);
        if (!hadExistingModifiers) {
            Multimap defaultModifiers = tool.m_41720_().m_7167_(EquipmentSlot.MAINHAND);
            for (Map.Entry entry : defaultModifiers.entries()) {
                tool.m_41643_((Attribute)entry.getKey(), (AttributeModifier)entry.getValue(), EquipmentSlot.MAINHAND);
            }
        }
        long expirationTick = level.m_46467_() + (long)(superchargeMinutes * 60 * 20);
        MutableComponent prefix = Component.m_237113_((String)"Supercharged ").m_130940_(ChatFormatting.AQUA).m_130938_(style -> style.m_131155_(Boolean.valueOf(false)));
        MutableComponent originalName = tool.m_41786_().m_6881_().m_130940_(ChatFormatting.WHITE).m_130938_(style -> style.m_131155_(Boolean.valueOf(false)));
        tool.m_41714_((Component)prefix.m_7220_((Component)originalName));
        CompoundTag mainTag = tool.m_41784_();
        CompoundTag upgradeTag = new CompoundTag();
        upgradeTag.m_128379_(TAG_MINING_BOOST, true);
        upgradeTag.m_128405_(TAG_SPEED_BOOST_LEVEL, digSpeedBuff);
        upgradeTag.m_128405_(TAG_DAMAGE_BOOST_LEVEL, attackDamageBuff);
        upgradeTag.m_128405_(TAG_ATTACK_SPEED_BOOST_LEVEL, attackSpeedBuff);
        upgradeTag.m_128356_(TAG_EXPIRATION, expirationTick);
        upgradeTag.m_128379_(TAG_WAS_UNBREAKABLE, wasAlreadyUnbreakable);
        upgradeTag.m_128379_(TAG_HAD_MODIFIERS, hadExistingModifiers);
        mainTag.m_128365_(TAG_UPGRADE_MAIN, (Tag)upgradeTag);
        if (((Boolean)DDConfigs.SUPERCHARGE_UNBREAKABLE.get()).booleanValue()) {
            mainTag.m_128379_("Unbreakable", true);
        }
        float damageMultiplier = (float)attackDamageBuff / 100.0f;
        float speedMultiplier = (float)attackSpeedBuff / 100.0f;
        AttributeModifier damageModifier = new AttributeModifier(ATTACK_DAMAGE_MODIFIER_UUID, "DarkerDepths Supercharge Damage", (double)damageMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier speedModifier = new AttributeModifier(ATTACK_SPEED_MODIFIER_UUID, "DarkerDepths Supercharge Speed", (double)speedMultiplier, AttributeModifier.Operation.MULTIPLY_BASE);
        tool.m_41643_(Attributes.f_22281_, damageModifier, EquipmentSlot.MAINHAND);
        tool.m_41643_(Attributes.f_22283_, speedModifier, EquipmentSlot.MAINHAND);
        tool.m_41654_(ItemStack.TooltipPart.MODIFIERS);
        tool.m_41654_(ItemStack.TooltipPart.UNBREAKABLE);
    }

    public static void revertUpgrades(ItemStack tool) {
        if (tool.m_41619_() || !tool.m_41782_()) {
            return;
        }
        CompoundTag mainTag = tool.m_41783_();
        if (mainTag == null || !mainTag.m_128441_(TAG_UPGRADE_MAIN)) {
            return;
        }
        CompoundTag upgradeTag = mainTag.m_128469_(TAG_UPGRADE_MAIN);
        boolean wasOriginallyUnbreakable = upgradeTag.m_128471_(TAG_WAS_UNBREAKABLE);
        boolean hadOriginalModifiers = upgradeTag.m_128471_(TAG_HAD_MODIFIERS);
        tool.m_41787_();
        mainTag.m_128473_("HideFlags");
        mainTag.m_128473_(TAG_UPGRADE_MAIN);
        if (!wasOriginallyUnbreakable) {
            mainTag.m_128473_("Unbreakable");
        }
        if (hadOriginalModifiers) {
            if (mainTag.m_128425_("AttributeModifiers", 9)) {
                ListTag modifiersList = mainTag.m_128437_("AttributeModifiers", 10);
                for (int i = modifiersList.size() - 1; i >= 0; --i) {
                    UUID uuid;
                    CompoundTag modifierTag = modifiersList.m_128728_(i);
                    if (!modifierTag.m_128403_("UUID") || !(uuid = modifierTag.m_128342_("UUID")).equals(ATTACK_DAMAGE_MODIFIER_UUID) && !uuid.equals(ATTACK_SPEED_MODIFIER_UUID)) continue;
                    modifiersList.remove(i);
                }
                if (modifiersList.isEmpty()) {
                    mainTag.m_128473_("AttributeModifiers");
                }
            }
        } else {
            mainTag.m_128473_("AttributeModifiers");
        }
        if (mainTag.m_128456_()) {
            tool.m_41751_(null);
        }
    }
}

