/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.world.gen.features;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.init.DDBlocks;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class AridBoulderFeature
extends Feature<NoneFeatureConfiguration> {
    public AridBoulderFeature(Codec<NoneFeatureConfiguration> codece) {
        super(codece);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos blockpos = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        RandomSource random = context.m_225041_();
        if (!world.m_46859_(blockpos) || !world.m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_13061_)) {
            return false;
        }
        boolean flag = false;
        int radius = 8;
        int height = Mth.m_216271_((RandomSource)random, (int)8, (int)16);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y <= height; ++y) {
                    BlockPos blockPos = new BlockPos(blockpos.m_123341_() + x, blockpos.m_123342_() - 3 + y, blockpos.m_123343_() + z);
                    if (y <= 1) continue;
                    flag = this.generateBoulder(world, flag, radius, x, z, y, blockPos);
                }
            }
        }
        return flag;
    }

    private boolean generateBoulder(WorldGenLevel world, boolean flag, int radius, int x, int z, int y, BlockPos blockPos) {
        if (y * (x * x) + y * y / 4 + y * (z * z) <= radius * radius) {
            if (world.m_7433_(blockPos.m_7495_(), state -> DripstoneUtils.m_159664_((BlockState)state) || state.m_60713_((Block)DDBlocks.DRY_SPROUTS.get()))) {
                if (blockPos.m_7495_().m_123342_() < world.m_141937_()) {
                    return false;
                }
                return this.generateBoulder(world, flag, radius, x / 2, z / 2, y, blockPos.m_7495_());
            }
            this.replaceLavaColumn(world, blockPos.m_7495_());
            Predicate<BlockState> canBeReplaced = blockState -> DripstoneUtils.m_159666_((BlockState)blockState) || blockState.m_204336_(BlockTags.f_13061_) || blockState.m_60713_((Block)DDBlocks.DRY_SPROUTS.get()) || blockState.m_60713_(Blocks.f_152475_);
            if (canBeReplaced.test(world.m_8055_(blockPos))) {
                Block block = y % 4 == 0 ? (Block)DDBlocks.ARIDROCK.get() : Blocks.f_220843_;
                world.m_7731_(blockPos, block.m_49966_(), 2);
                flag = true;
            }
        }
        return flag;
    }

    private void replaceLavaColumn(WorldGenLevel world, BlockPos pos) {
        if (pos.m_123342_() < world.m_141937_()) {
            return;
        }
        if (world.m_8055_(pos).m_60713_(Blocks.f_49991_)) {
            world.m_7731_(pos, ((Block)DDBlocks.DARKSLATE.get()).m_49966_(), 2);
            this.replaceLavaColumn(world, pos.m_7495_());
        }
    }
}

