/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import com.xiaoyu.suixingxiugai.config.iceandfire.entity.CyclopsConfig;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityCyclops.class})
public abstract class EntityCyclopsMixin
extends Monster {
    protected EntityCyclopsMixin(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Redirect(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean redirectBiteDamage(Entity entity, DamageSource source, float amount) {
        return entity.m_6469_(source, (float)((Double)CyclopsConfig.cyclopsBiteStrength.get()).doubleValue());
    }

    @Inject(method={"doHurtTarget(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDoHurtTarget(Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        EntityCyclops cyclops = (EntityCyclops)this;
        boolean canStomp = (Boolean)CyclopsConfig.cyclopsCanStompAttack.get();
        boolean canGrab = (Boolean)CyclopsConfig.cyclopsCanGrabAttack.get();
        boolean canKick = (Boolean)CyclopsConfig.cyclopsCanKickAttack.get();
        if (!(canStomp || canGrab || canKick)) {
            cir.setReturnValue((Object)false);
            return;
        }
        int attackDecision = cyclops.m_217043_().m_188503_(3);
        boolean attackPerformed = this.tryPerformAttack(cyclops, entityIn, attackDecision, canStomp, canGrab, canKick);
        if (!attackPerformed) {
            for (int i = 0; i < 3 && !attackPerformed; ++i) {
                if (i == attackDecision) continue;
                attackPerformed = this.tryPerformAttack(cyclops, entityIn, i, canStomp, canGrab, canKick);
            }
        }
        cir.setReturnValue((Object)attackPerformed);
    }

    private boolean tryPerformAttack(EntityCyclops cyclops, Entity target, int attackType, boolean canStomp, boolean canGrab, boolean canKick) {
        switch (attackType) {
            case 0: {
                if (!canStomp) break;
                cyclops.setAnimation(EntityCyclops.ANIMATION_STOMP);
                return true;
            }
            case 1: {
                if (!canGrab) break;
                if (!target.m_20363_((Entity)cyclops) && target.m_20205_() < 1.95f && !(target instanceof EntityDragonBase) && !target.m_6095_().m_204039_(ForgeRegistries.ENTITY_TYPES.tags().createTagKey(IafTagRegistry.CYCLOPS_UNLIFTABLES))) {
                    cyclops.setAnimation(EntityCyclops.ANIMATION_EATPLAYER);
                    target.m_8127_();
                    target.m_7998_((Entity)cyclops, true);
                    return true;
                }
                if (!canStomp) break;
                cyclops.setAnimation(EntityCyclops.ANIMATION_STOMP);
                return true;
            }
            case 2: {
                if (!canKick) break;
                cyclops.setAnimation(EntityCyclops.ANIMATION_KICK);
                return true;
            }
        }
        return false;
    }
}

