/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.iceandfire.entity;

import com.github.alexthe666.iceandfire.block.BlockIceSpikes;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IafDragonDestructionManager;
import com.xiaoyu.suixingxiugai.util.BlockOwnerTracker;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={IafDragonDestructionManager.class})
public class IafDragonDestructionManagerMixin {
    @Inject(method={"attackBlock(Lnet/minecraft/world/level/Level;Lcom/github/alexthe666/iceandfire/entity/EntityDragonBase;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", shift=At.Shift.AFTER, ordinal=1)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void onSetBlockAndUpdate(Level level, EntityDragonBase dragon, BlockPos position, BlockState state, CallbackInfo ci, BlockState transformed, Block elementalBlock, boolean doPlaceBlock, BlockState stateAbove) {
        UUID ownerUUID;
        if ((elementalBlock == Blocks.f_50083_ || elementalBlock == IafBlockRegistry.DRAGON_ICE_SPIKES.get()) && (ownerUUID = IafDragonDestructionManagerMixin.getDragonOwnerUUID(dragon)) != null) {
            IafDragonDestructionManagerMixin.markBlockWithOwner(level, position.m_7494_(), ownerUUID);
        }
    }

    @Nullable
    private static UUID getDragonOwnerUUID(EntityDragonBase dragon) {
        if (dragon.m_21824_() && dragon.m_269323_() != null) {
            return dragon.m_269323_().m_20148_();
        }
        return null;
    }

    private static void markBlockWithOwner(Level level, BlockPos pos, UUID ownerUUID) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof BlockIceSpikes || state.m_60734_() == Blocks.f_50083_) {
            CompoundTag blockEntityTag = new CompoundTag();
            blockEntityTag.m_128362_("DragonOwner", ownerUUID);
            BlockOwnerTracker.setBlockOwner(pos, ownerUUID);
        }
    }
}

