/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.iceandfire.item;

import com.github.alexthe666.iceandfire.item.ItemCyclopsEye;
import com.xiaoyu.suixingxiugai.config.iceandfire.item.CyclopsEyeConfig;
import com.xiaoyu.suixingxiugai.util.EntityTypeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemCyclopsEye.class})
public class ItemCyclopsEyeMixin {
    private static final ThreadLocal<Boolean> ABOUT_TO_BREAK = ThreadLocal.withInitial(() -> false);

    @Inject(method={"inventoryTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V")})
    private void onAboutToBreak(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected, CallbackInfo ci) {
        ABOUT_TO_BREAK.set(true);
    }

    @Inject(method={"inventoryTick"}, at={@At(value="TAIL")})
    private void onInventoryTickEnd(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected, CallbackInfo ci) {
        if (ABOUT_TO_BREAK.get().booleanValue() && stack.m_41619_() && entity instanceof LivingEntity && ((Boolean)CyclopsEyeConfig.cyclopsEyePlayBreakSound.get()).booleanValue()) {
            world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        ABOUT_TO_BREAK.set(false);
    }

    @ModifyConstant(method={"inventoryTick"}, constant={@Constant(doubleValue=15.0)})
    private double modifyRange(double original) {
        return (Double)CyclopsEyeConfig.cyclopsEyePotionEffectRadius.get();
    }

    @ModifyConstant(method={"inventoryTick"}, constant={@Constant(intValue=10)})
    private int modifyPotionDuration(int original) {
        return (Integer)CyclopsEyeConfig.cyclopsEyePotionEffectDuration.get();
    }

    @ModifyConstant(method={"inventoryTick"}, constant={@Constant(intValue=1)})
    private int modifyPotionLevel(int original) {
        return (Integer)CyclopsEyeConfig.cyclopsEyePotionEffectLevel.get();
    }

    @ModifyConstant(method={"inventoryTick"}, constant={@Constant(intValue=120)})
    private int modifyHurtingTicksThreshold(int original) {
        return (Integer)CyclopsEyeConfig.cyclopsEyeDurabilityReductionSpeed.get();
    }

    @Redirect(method={"inventoryTick"}, at=@At(value="FIELD", target="Lnet/minecraft/world/effect/MobEffects;WEAKNESS:Lnet/minecraft/world/effect/MobEffect;"))
    private MobEffect redirectPotionEffect() {
        return this.getEffect();
    }

    private MobEffect getEffect() {
        String effectId = (String)CyclopsEyeConfig.cyclopsEyePotionEffectId.get();
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectId));
    }

    @Redirect(method={"inventoryTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V"))
    private void redirectDurabilityReduction(ItemStack stack, int amount, LivingEntity entity, Consumer<LivingEntity> onBroken) {
        stack.m_41622_(((Integer)CyclopsEyeConfig.cyclopsEyeDurabilityReduction.get()).intValue(), entity, onBroken);
    }

    @Redirect(method={"inventoryTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;"))
    private <T extends Entity> List<T> redirectGetEntitiesOfClass(Level world, Class<T> entityClass, AABB boundingBox) {
        return new ArrayList();
    }

    @Inject(method={"inventoryTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;", shift=At.Shift.AFTER)})
    private void injectCustomLogic(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected, CallbackInfo ci) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.m_21205_() != stack && living.m_21206_() != stack) {
            return;
        }
        String targetType = (String)CyclopsEyeConfig.cyclopsEyeTargetEntityType.get();
        double range = (Double)CyclopsEyeConfig.cyclopsEyePotionEffectRadius.get();
        int duration = (Integer)CyclopsEyeConfig.cyclopsEyePotionEffectDuration.get();
        int level = (Integer)CyclopsEyeConfig.cyclopsEyePotionEffectLevel.get();
        int minMobs = (Integer)CyclopsEyeConfig.cyclopsEyeMinAffectedMobs.get();
        Class<? extends Entity> targetClass = this.getTargetClass(targetType);
        List entities = world.m_45976_(targetClass, new AABB(living.m_20185_() - range, living.m_20186_() - range, living.m_20189_() - range, living.m_20185_() + range, living.m_20186_() + range, living.m_20189_() + range));
        if (entities.size() < minMobs) {
            return;
        }
        MobEffect effect = this.getEffect();
        boolean inflictedDamage = false;
        for (Entity targetEntity : entities) {
            if (!this.shouldApplyEffect(targetEntity, living, targetType) || !(targetEntity instanceof LivingEntity)) continue;
            LivingEntity targetLiving = (LivingEntity)targetEntity;
            targetLiving.m_7292_(new MobEffectInstance(effect, duration, level));
            inflictedDamage = true;
        }
        if (inflictedDamage && stack.m_41783_() != null) {
            stack.m_41783_().m_128405_("HurtingTicks", stack.m_41783_().m_128451_("HurtingTicks") + 1);
        }
    }

    private boolean shouldApplyEffect(Entity targetEntity, LivingEntity holder, String targetType) {
        if (targetEntity == holder) {
            return false;
        }
        if (targetEntity instanceof Mob) {
            Mob targetMob = (Mob)targetEntity;
            if (targetType.equalsIgnoreCase("mob")) {
                return !targetMob.m_7307_((Entity)holder) && (targetMob.m_5448_() == holder || targetMob.m_21188_() == holder || targetMob instanceof Enemy);
            }
            return !targetMob.m_7307_((Entity)holder);
        }
        return !targetType.equalsIgnoreCase("mob");
    }

    private Class<? extends Entity> getTargetClass(String targetType) {
        return EntityTypeHelper.getTargetClass(targetType);
    }
}

