/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.minecraft.entity;

import com.xiaoyu.suixingxiugai.config.SuixingxiugaiConfig;
import com.xiaoyu.suixingxiugai.config.twilightforest.item.wand.FortificationWandConfig;
import com.xiaoyu.suixingxiugai.event.CriticalHitEventHandler;
import com.xiaoyu.suixingxiugai.network.DamageDisplayMessage;
import com.xiaoyu.suixingxiugai.network.NetworkHandler;
import com.xiaoyu.suixingxiugai.util.EntityTypeHelper;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity;
        if (((Boolean)FortificationWandConfig.enableFortificationWandInvulnerability.get()).booleanValue() && LivingEntityMixin.hasShieldsViaReflection(entity = (LivingEntity)this)) {
            cir.cancel();
        }
    }

    private static boolean hasShieldsViaReflection(LivingEntity entity) {
        try {
            Optional optionalCap;
            Method resolveMethod;
            Object capOptional;
            Class<?> capabilityListClass = Class.forName("twilightforest.capabilities.CapabilityList");
            Object shieldCapability = capabilityListClass.getField("SHIELDS").get(null);
            Object lazyOptional = entity.getClass().getMethod("getCapability", Class.forName("net.minecraftforge.common.capabilities.Capability")).invoke((Object)entity, shieldCapability);
            boolean isPresent = (Boolean)lazyOptional.getClass().getMethod("isPresent", new Class[0]).invoke(lazyOptional, new Object[0]);
            if (isPresent && (capOptional = (resolveMethod = lazyOptional.getClass().getMethod("resolve", new Class[0])).invoke(lazyOptional, new Object[0])) instanceof Optional && (optionalCap = (Optional)capOptional).isPresent()) {
                Object capInstance = optionalCap.get();
                int shieldsLeft = (Integer)capInstance.getClass().getMethod("shieldsLeft", new Class[0]).invoke(capInstance, new Object[0]);
                return shieldsLeft > 0;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="TAIL")})
    private void onActuallyHurt(DamageSource damageSrc, float damageAmount, CallbackInfo ci) {
        boolean matchesEntityList;
        if (this instanceof Player) {
            return;
        }
        if (!((Boolean)SuixingxiugaiConfig.enableDamageNumberDisplay.get()).booleanValue()) {
            return;
        }
        LivingEntity entity = (LivingEntity)this;
        ResourceLocation entityTypeId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        String entityTypeIdStr = entityTypeId.toString();
        String entityTypeConfig = (String)SuixingxiugaiConfig.damageNumberDisplayEntityTypes.get();
        List entityListConfig = (List)SuixingxiugaiConfig.damageNumberDisplayEntities.get();
        List blacklistEntitiesConfig = (List)SuixingxiugaiConfig.damageNumberDisplayBlacklistEntities.get();
        boolean isBlacklisted = blacklistEntitiesConfig.contains(entityTypeIdStr);
        if (isBlacklisted) {
            return;
        }
        boolean matchesEntityType = EntityTypeHelper.matchesEntityType(entity, entityTypeConfig);
        boolean bl = matchesEntityList = entityListConfig.isEmpty() || entityListConfig.contains(entityTypeIdStr);
        if (!entity.m_9236_().f_46443_ && matchesEntityType && matchesEntityList && damageAmount != 0.0f) {
            boolean isCrit = false;
            if (damageSrc.m_276093_(DamageTypes.f_268464_)) {
                isCrit = CriticalHitEventHandler.isLastAttackCritical((Entity)entity);
            }
            DamageDisplayMessage message = new DamageDisplayMessage(entity, damageAmount, damageSrc, isCrit);
            NetworkHandler.sendToAllTracking((Entity)entity, message);
        }
    }
}

