/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.twilightforest.entity.boss;

import com.xiaoyu.suixingxiugai.config.twilightforest.entity.LichConfig;
import com.xiaoyu.suixingxiugai.util.twilightforest.entity.LichTeleportUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import twilightforest.entity.boss.IBossLootBuffer;
import twilightforest.entity.boss.Lich;
import twilightforest.init.TFSounds;

@Mixin(value={Lich.class})
public abstract class LichMixin {
    @Shadow
    private ServerBossEvent bossInfo;
    @Unique
    private DamageSource currentDamageSource;

    @Accessor(value="SHIELD_STRENGTH")
    public static EntityDataAccessor<Integer> getShieldStrengthAccessor() {
        throw new AssertionError();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void modifyAttributes(CallbackInfo ci) {
        AttributeInstance attackDamageAttribute;
        AttributeInstance movementSpeedAttribute;
        Lich lich = (Lich)this;
        AttributeInstance maxHealthAttribute = lich.m_21051_(Attributes.f_22276_);
        if (maxHealthAttribute != null) {
            maxHealthAttribute.m_22100_(((Double)LichConfig.lichMaxHealth.get()).doubleValue());
            if ((double)lich.m_21223_() > (Double)LichConfig.lichMaxHealth.get()) {
                lich.m_21153_((float)((Double)LichConfig.lichMaxHealth.get()).doubleValue());
            }
        }
        if ((movementSpeedAttribute = lich.m_21051_(Attributes.f_22279_)) != null) {
            movementSpeedAttribute.m_22100_(((Double)LichConfig.lichMovementSpeed.get()).doubleValue());
        }
        if ((attackDamageAttribute = lich.m_21051_(Attributes.f_22281_)) != null) {
            attackDamageAttribute.m_22100_(((Double)LichConfig.lichAttackDamage.get()).doubleValue());
        }
    }

    @ModifyConstant(method={"<init>"}, constant={@Constant(intValue=217)})
    private int modifyXpReward(int original) {
        return (Integer)LichConfig.lichXpReward.get();
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")})
    private void suixingxiugai$storeDamageSource(DamageSource src, float damage, CallbackInfoReturnable<Boolean> cir) {
        this.currentDamageSource = src;
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Ltwilightforest/entity/boss/Lich;getShieldStrength()I", ordinal=0)}, cancellable=true)
    private void suixingxiugai$handlePhysicalDamageShield(DamageSource src, float damage, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)LichConfig.enableLichShieldModification.get()).booleanValue()) {
            return;
        }
        Lich lich = (Lich)this;
        if (lich.getShieldStrength() > 0 && this.isEntityCausedDamage(src)) {
            lich.setShieldStrength(lich.getShieldStrength() - 1);
            lich.m_5496_((SoundEvent)TFSounds.SHIELD_BREAK.get(), 1.0f, lich.m_6100_() * 2.0f);
            lich.m_146850_(GameEvent.f_223706_);
            cir.cancel();
            cir.setReturnValue((Object)false);
        }
    }

    private boolean isEntityCausedDamage(DamageSource source) {
        Entity directEntity = source.m_7640_();
        Entity entity = source.m_7639_();
        return directEntity != null || entity != null;
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void suixingxiugai$modifyInitialShieldStrength(CallbackInfo ci) {
        Lich lich = (Lich)this;
        SynchedEntityData entityData = lich.m_20088_();
        entityData.m_135381_(LichMixin.getShieldStrengthAccessor(), (Object)((Integer)LichConfig.lichShieldStrength.get()));
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerBossEvent;setProgress(F)V", ordinal=0, shift=At.Shift.AFTER)})
    private void suixingxiugai$modifyShieldPhaseBossBar(CallbackInfo ci) {
        Lich lich = (Lich)this;
        if (!lich.m_9236_().m_5776_() && lich.getPhase() == 1) {
            int maxShield = (Integer)LichConfig.lichShieldStrength.get();
            float progress = (float)lich.getShieldStrength() / (float)maxShield;
            this.bossInfo.m_142711_(Math.max(0.0f, Math.min(1.0f, progress)));
            if (maxShield > 6 && this.bossInfo.m_18863_() == BossEvent.BossBarOverlay.NOTCHED_6) {
                this.bossInfo.m_5648_(BossEvent.BossBarOverlay.PROGRESS);
            }
        }
    }

    @Redirect(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="INVOKE", target="Ltwilightforest/entity/boss/Lich;isShadowClone()Z"))
    private boolean suixingxiugai$redirectIsShadowClone(Lich lich) {
        boolean isClone = lich.isShadowClone();
        if (!isClone) {
            return false;
        }
        if (this.currentDamageSource != null && this.currentDamageSource.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return (Boolean)LichConfig.lichPhantomCanBeAttacked.get() == false;
    }

    @Redirect(method={"remove(Lnet/minecraft/world/entity/Entity$RemovalReason;)V"}, at=@At(value="INVOKE", target="Ltwilightforest/entity/boss/IBossLootBuffer;depositDropsIntoChest(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/server/level/ServerLevel;)V"))
    private void suixingxiugai$controlPhantomChestDrop(LivingEntity lich, BlockState chest, BlockPos pos, ServerLevel serverLevel) {
        if (lich instanceof Lich) {
            Lich l = (Lich)lich;
            if (l.isShadowClone()) {
                if (((Boolean)LichConfig.lichPhantomDropChest.get()).booleanValue()) {
                    IBossLootBuffer.depositDropsIntoChest((LivingEntity)l, (BlockState)chest, (BlockPos)pos, (ServerLevel)serverLevel);
                }
            } else {
                IBossLootBuffer.depositDropsIntoChest((LivingEntity)l, (BlockState)chest, (BlockPos)pos, (ServerLevel)serverLevel);
            }
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Ltwilightforest/entity/boss/Lich;teleportToSightOfEntity(Lnet/minecraft/world/entity/Entity;)V")}, cancellable=true)
    private void suixingxiugai$controlLichHurtTeleport(DamageSource src, float damage, CallbackInfoReturnable<Boolean> cir) {
        Lich lich = (Lich)this;
        LichTeleportUtil.checkAndCancelTeleport(lich, cir);
    }
}

