/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.twilightforest.item.wand;

import com.xiaoyu.suixingxiugai.config.twilightforest.item.wand.FortificationWandConfig;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.item.FortificationWandItem;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateShieldPacket;

@Mixin(value={FortificationWandItem.class})
public class FortificationWandItemMixin {
    @Inject(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUse(Level level, Player player, @Nonnull InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        Entity targetEntity;
        Entity target;
        LazyOptional shieldCapability;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41773_() >= (Integer)FortificationWandConfig.fortificationWandUses.get()) {
            cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)stack));
            return;
        }
        if (!level.m_5776_() && (shieldCapability = (target = (targetEntity = (Boolean)FortificationWandConfig.enableFortificationWandTargeting.get() != false ? FortificationWandItemMixin.getEntityAtCursor(player, 20.0) : null) != null ? targetEntity : player).getCapability(CapabilityList.SHIELDS)).isPresent()) {
            shieldCapability.ifPresent(cap -> {
                cap.replenishShields();
                cap.setShields(((Integer)FortificationWandConfig.fortificationWandShieldAmount.get()).intValue(), true);
                FortificationWandItemMixin.sendShieldUpdatePacket(target, cap);
            });
            if (!player.m_7500_()) {
                stack.m_220157_(1, level.m_213780_(), null);
            }
        }
        if (!player.m_7500_()) {
            player.m_36335_().m_41524_(stack.m_41720_(), ((Integer)FortificationWandConfig.fortificationWandCooldown.get()).intValue());
        }
        cir.setReturnValue((Object)InteractionResultHolder.m_19090_((Object)stack));
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)FortificationWandConfig.fortificationWandUses.get();
    }

    private static void sendShieldUpdatePacket(Entity entity, IShieldCapability cap) {
        TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new UpdateShieldPacket(entity, cap));
    }

    private static Entity getEntityAtCursor(Player player, double range) {
        Vec3 srcVec = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 destVec = srcVec.m_82520_(lookVec.f_82479_ * range, lookVec.f_82480_ * range, lookVec.f_82481_ * range);
        float boundingBoxExpansion = 1.0f;
        List possibleList = player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82363_(lookVec.f_82479_ * range, lookVec.f_82480_ * range, lookVec.f_82481_ * range).m_82377_((double)boundingBoxExpansion, (double)boundingBoxExpansion, (double)boundingBoxExpansion));
        double closestDistance = 0.0;
        Entity pointedEntity = null;
        for (Entity possibleEntity : possibleList) {
            double distance;
            if (!possibleEntity.m_6087_() || possibleEntity == player) continue;
            float borderSize = possibleEntity.m_6143_();
            AABB collisionBB = possibleEntity.m_20191_().m_82377_((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
            if (collisionBB.m_82390_(srcVec)) {
                if (!(0.0 < closestDistance) && closestDistance != 0.0) continue;
                pointedEntity = possibleEntity;
                closestDistance = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((distance = srcVec.m_82557_((Vec3)interceptPos.get())) < closestDistance) && closestDistance != 0.0) continue;
            pointedEntity = possibleEntity;
            closestDistance = distance;
        }
        return pointedEntity;
    }
}

