/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.network;

import com.xiaoyu.suixingxiugai.client.ClientEvents;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class DamageDisplayMessage {
    private final int entityId;
    private final float damageAmount;
    private final ResourceLocation damageType;
    private final boolean isCrit;

    public DamageDisplayMessage(int entityId, float damageAmount, ResourceLocation damageType, boolean isCrit) {
        this.entityId = entityId;
        this.damageAmount = damageAmount;
        this.damageType = damageType;
        this.isCrit = isCrit;
    }

    public DamageDisplayMessage(LivingEntity entity, float damageAmount, DamageSource source, boolean isCrit) {
        this(entity.m_19879_(), damageAmount, ((ResourceKey)source.m_269150_().m_203543_().get()).m_135782_(), isCrit);
    }

    public static void encode(DamageDisplayMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeFloat(msg.damageAmount);
        buf.m_130085_(msg.damageType);
        buf.writeBoolean(msg.isCrit);
    }

    public static DamageDisplayMessage decode(FriendlyByteBuf buf) {
        return new DamageDisplayMessage(buf.readInt(), buf.readFloat(), buf.m_130281_(), buf.readBoolean());
    }

    public static void handle(DamageDisplayMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                Entity entity;
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ != null && (entity = mc.f_91073_.m_6815_(msg.entityId)) != null) {
                    entity.m_9236_().m_7106_((ParticleOptions)ClientEvents.DAMAGE_NUMBER.get(), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), (double)msg.damageAmount, 0.0, msg.isCrit ? 1.0 : 0.0);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public float getDamageAmount() {
        return this.damageAmount;
    }

    public ResourceLocation getDamageType() {
        return this.damageType;
    }

    public boolean isCrit() {
        return this.isCrit;
    }
}

