/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.command;

import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class StatueRestoreCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"iceandfire").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"statuerestore").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> StatueRestoreCommand.execute((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"targets"))))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int successCount = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof EntityStoneStatue)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.iceandfire.statuerestore.not_statue"));
                continue;
            }
            EntityStoneStatue statue = (EntityStoneStatue)entity;
            String entityTypeString = statue.getTrappedEntityTypeString();
            CompoundTag entityData = statue.getTrappedTag();
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)entityTypeString));
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.iceandfire.statuerestore.invalid_entity_type"));
                continue;
            }
            ServerLevel level = (ServerLevel)statue.m_9236_();
            Entity originalEntity = entityType.m_20615_((Level)level);
            if (originalEntity == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.iceandfire.statuerestore.restore_failed", (Object[])new Object[]{statue.m_5446_().getString()}));
                continue;
            }
            try {
                originalEntity.m_20258_(entityData);
            }
            catch (Exception e) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.iceandfire.statuerestore.restore_failed", (Object[])new Object[]{statue.m_5446_().getString()}));
                continue;
            }
            originalEntity.m_19890_(statue.m_20185_(), statue.m_20186_(), statue.m_20189_(), statue.m_146908_(), statue.m_146909_());
            if (originalEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)originalEntity;
                living.f_20883_ = statue.f_20883_;
                living.f_20885_ = statue.f_20885_;
            }
            statue.m_142687_(Entity.RemovalReason.DISCARDED);
            level.m_7967_(originalEntity);
            ++successCount;
            String entityName = originalEntity.m_7755_().getString();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.iceandfire.statuerestore.success", (Object[])new Object[]{entityName}), true);
        }
        return successCount;
    }
}

