/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.xiaoyu.suixingxiugai.config.iceandfire.entity.hydra.HydraConfig;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityHydra.class})
public abstract class HydraDamageMixin
extends Monster {
    @Unique
    private float cumulativeDamage = 0.0f;

    protected HydraDamageMixin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHydraHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        double singleHitThreshold = (Double)HydraConfig.singleHitDamageToKill.get();
        if ((double)amount >= singleHitThreshold) {
            EntityHydra hydra = (EntityHydra)this;
            hydra.m_21153_(0.0f);
            return;
        }
        this.cumulativeDamage += amount;
        double cumulativeThreshold = (Double)HydraConfig.cumulativeDamageToKill.get();
        if ((double)this.cumulativeDamage >= cumulativeThreshold) {
            EntityHydra hydra = (EntityHydra)this;
            hydra.m_21153_(0.0f);
            return;
        }
        List damageTypesToKill = (List)HydraConfig.damageTypesToKill.get();
        String damageType = source.m_269415_().f_268677_();
        for (String killType : damageTypesToKill) {
            if (!damageType.equals(killType)) continue;
            EntityHydra hydra = (EntityHydra)this;
            hydra.m_21153_(0.0f);
            return;
        }
    }
}

