/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.util.iceandfire;

import com.xiaoyu.suixingxiugai.config.iceandfire.entity.GazeImmunityConfig;
import com.xiaoyu.suixingxiugai.util.ItemConfigHelper;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GazeImmunityHelper {
    public static boolean isImmuneToGazeAttack(LivingEntity entity) {
        if (GazeImmunityHelper.hasGazeImmunityItems() && ItemConfigHelper.isWearingArmorFromConfig(entity, (List)GazeImmunityConfig.gazeImmunityArmorList.get())) {
            return true;
        }
        if (GazeImmunityHelper.hasGazeImmunityInventoryItems()) {
            for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND}) {
                ItemStack stack = entity.m_6844_(slot);
                if (stack.m_41619_() || !ItemConfigHelper.isItemMatchConfig(stack, (List)GazeImmunityConfig.gazeImmunityItemList.get())) continue;
                return true;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack stack = player.m_150109_().m_8020_(i);
                    if (stack.m_41619_() || !ItemConfigHelper.isItemMatchConfig(stack, (List)GazeImmunityConfig.gazeImmunityItemList.get())) continue;
                    return true;
                }
            }
        }
        return GazeImmunityHelper.hasGazeImmunityCuriosItems() && ItemConfigHelper.isWearingCuriosFromConfig(entity, (List)GazeImmunityConfig.gazeImmunityCuriosList.get());
    }

    public static boolean isGorgonBlindedByWearingImmunityItems(LivingEntity gorgon) {
        return GazeImmunityHelper.hasGazeImmunityItems() || GazeImmunityHelper.hasGazeImmunityInventoryItems() || GazeImmunityHelper.hasGazeImmunityCuriosItems();
    }

    public static boolean hasGazeImmunityItems() {
        List immunityItems = (List)GazeImmunityConfig.gazeImmunityArmorList.get();
        return !immunityItems.isEmpty();
    }

    public static boolean hasGazeImmunityInventoryItems() {
        List immunityItems = (List)GazeImmunityConfig.gazeImmunityItemList.get();
        return !immunityItems.isEmpty();
    }

    public static boolean hasGazeImmunityCuriosItems() {
        List immunityItems = (List)GazeImmunityConfig.gazeImmunityCuriosList.get();
        return !immunityItems.isEmpty();
    }
}

