/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.xiaoyu.suixingxiugai.config.SuixingxiugaiConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DamageNumberParticle
extends Particle {
    private final Font fontRenderer;
    private final Component text;
    private final int color;
    private final int darkColor;
    private final boolean isCrit;
    private float fadeout;
    private float prevFadeout;
    private float visualDY;
    private float prevVisualDY;
    private float visualDX;
    private float prevVisualDX;

    public DamageNumberParticle(ClientLevel clientLevel, double x, double y, double z, double damageAmount, double critData) {
        super(clientLevel, x, y, z);
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        this.fadeout = -1.0f;
        this.prevFadeout = -1.0f;
        this.visualDY = 0.0f;
        this.prevVisualDY = 0.0f;
        this.visualDX = 0.0f;
        this.prevVisualDX = 0.0f;
        this.f_107225_ = 35;
        boolean bl = this.isCrit = critData > 0.0;
        if (this.isCrit) {
            String critColorString = (String)SuixingxiugaiConfig.critDamageNumberColor.get();
            this.color = this.parseColor(critColorString);
        } else {
            String colorString = (String)SuixingxiugaiConfig.damageNumberColor.get();
            this.color = this.parseColor(colorString);
        }
        int red = this.color >> 16 & 0xFF;
        int green = this.color >> 8 & 0xFF;
        int blue = this.color & 0xFF;
        this.darkColor = 0xFF000000 | (int)((float)red * 0.25f) << 16 | (int)((float)green * 0.25f) << 8 | (int)((float)blue * 0.25f);
        this.text = Component.m_237113_((String)String.format("%.1f", Math.abs(damageAmount)));
        this.f_107216_ = 1.0;
        this.f_107215_ = this.isCrit ? ((double)clientLevel.f_46441_.m_188501_() - 0.5) * 1.0 : ((double)clientLevel.f_46441_.m_188501_() - 0.5) * 0.5;
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPos = camera.m_90583_();
        float particleX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float particleY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float particleZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        int light = 0xF000F0;
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_252880_(particleX, particleY, particleZ);
        double distanceFromCam = new Vec3((double)particleX, (double)particleY, (double)particleZ).m_82553_();
        double inc = Mth.m_14008_((double)(distanceFromCam / 32.0), (double)0.0, (double)5.0);
        poseStack.m_85837_(0.0, (1.0 + inc / 4.0) * (double)Mth.m_14179_((float)partialTicks, (float)this.prevVisualDY, (float)this.visualDY), 0.0);
        float fadeout = Mth.m_14179_((float)partialTicks, (float)this.prevFadeout, (float)this.fadeout);
        float defScale = 0.006f;
        float scale = (float)((double)defScale * distanceFromCam);
        if (this.isCrit) {
            scale *= 1.5f;
        }
        poseStack.m_252781_(camera.m_253121_());
        poseStack.m_85837_((1.0 + inc) * (double)Mth.m_14179_((float)partialTicks, (float)this.prevVisualDX, (float)this.visualDX), 0.0, 0.0);
        poseStack.m_85841_(-scale, -scale, scale);
        poseStack.m_85837_(0.0, 4.0 * (double)(1.0f - fadeout), 0.0);
        poseStack.m_85841_(fadeout, fadeout, fadeout);
        poseStack.m_85837_(0.0, -distanceFromCam / 10.0, 0.0);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        float x1 = 0.5f - (float)this.fontRenderer.m_92852_((FormattedText)this.text) / 2.0f;
        this.fontRenderer.m_272077_(this.text, x1, 0.0f, this.color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, light);
        poseStack.m_85837_(1.0, 1.0, 0.03);
        this.fontRenderer.m_272077_(this.text, x1, 0.0f, this.darkColor, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, light);
        buffer.m_109911_();
        poseStack.m_85849_();
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            float length = 6.0f;
            this.prevFadeout = this.fadeout;
            this.fadeout = (float)this.f_107224_ > (float)this.f_107225_ - length ? ((float)this.f_107225_ - (float)this.f_107224_) / length : 1.0f;
            this.prevVisualDY = this.visualDY;
            this.visualDY += (float)this.f_107216_;
            this.prevVisualDX = this.visualDX;
            this.visualDX += (float)this.f_107215_;
            if (Math.sqrt(Mth.m_144952_((double)((double)this.visualDX * 1.5)) + (double)Mth.m_14207_((float)(this.visualDY - 1.0f))) < 0.8999999999999999) {
                this.f_107216_ /= 2.0;
            } else {
                this.f_107216_ = 0.0;
                this.f_107215_ = 0.0;
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    private int parseColor(String colorString) {
        try {
            if (colorString.startsWith("#")) {
                colorString = colorString.substring(1);
            }
            return (int)Long.parseLong(colorString, 16);
        }
        catch (Exception e) {
            return this.isCrit ? 0xFF0000 : 0xFFFFFF;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet spriteSet) {
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DamageNumberParticle(worldIn, x, y, z, xSpeed, zSpeed);
        }
    }
}

