/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.event;

import com.xiaoyu.suixingxiugai.config.SuixingxiugaiConfig;
import com.xiaoyu.suixingxiugai.util.EntityTypeHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DamageRandomizationEventHandler {
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (!((Boolean)SuixingxiugaiConfig.enableDamageRandomization.get()).booleanValue()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!DamageRandomizationEventHandler.isEntityEligible(entity)) {
            return;
        }
        float originalDamage = event.getAmount();
        float randomizedDamage = DamageRandomizationEventHandler.randomizeDamage(originalDamage);
        event.setAmount(randomizedDamage);
    }

    private static boolean isEntityEligible(LivingEntity entity) {
        String entityName;
        String entityType = (String)SuixingxiugaiConfig.damageRandomizationEntityTypes.get();
        List entities = (List)SuixingxiugaiConfig.damageRandomizationEntities.get();
        if (!entities.isEmpty() && entities.contains(entityName = EntityType.m_20613_((EntityType)entity.m_6095_()).toString())) {
            return true;
        }
        if (!entityType.isEmpty()) {
            return EntityTypeHelper.isEntityOfType(entity, entityType);
        }
        return false;
    }

    private static float randomizeDamage(float originalDamage) {
        double maxMultiplier;
        double minMultiplier = (Double)SuixingxiugaiConfig.damageRandomizationMinMultiplier.get();
        if (minMultiplier > (maxMultiplier = ((Double)SuixingxiugaiConfig.damageRandomizationMaxMultiplier.get()).doubleValue())) {
            double temp = minMultiplier;
            minMultiplier = maxMultiplier;
            maxMultiplier = temp;
        }
        double range = maxMultiplier - minMultiplier;
        double multiplier = minMultiplier + RANDOM.nextDouble() * range;
        return (float)((double)originalDamage * multiplier);
    }
}

