/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.event.iceandfire.entity;

import com.xiaoyu.suixingxiugai.config.iceandfire.entity.DreadMobConfig;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="suixingxiugai", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DreadMobTargetHandler {
    private static boolean initialized = false;
    private static Class<?> dreadLichClass = null;
    private static Class<?> dreadThrallClass = null;
    private static Class<?> dreadBeastClass = null;
    private static Class<?> dreadGhoulClass = null;
    private static Class<?> dreadScuttlerClass = null;
    private static Class<?> dreadKnightClass = null;
    private static Class<?> dreadHorseClass = null;

    private static void initialize() {
        if (initialized) {
            return;
        }
        try {
            dreadLichClass = Class.forName("com.github.alexthe666.iceandfire.entity.EntityDreadLich");
            dreadThrallClass = Class.forName("com.github.alexthe666.iceandfire.entity.EntityDreadThrall");
            dreadBeastClass = Class.forName("com.github.alexthe666.iceandfire.entity.EntityDreadBeast");
            dreadGhoulClass = Class.forName("com.github.alexthe666.iceandfire.entity.EntityDreadGhoul");
            dreadScuttlerClass = Class.forName("com.github.alexthe666.iceandfire.entity.EntityDreadScuttler");
            dreadKnightClass = Class.forName("com.github.alexthe666.iceandfire.entity.EntityDreadKnight");
            dreadHorseClass = Class.forName("com.github.alexthe666.iceandfire.entity.EntityDreadHorse");
        }
        catch (ClassNotFoundException | ExceptionInInitializerError throwable) {
            // empty catch block
        }
        initialized = true;
    }

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        DreadMobTargetHandler.initialize();
        if (dreadLichClass == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        LivingEntity target = event.getOriginalTarget();
        if (!(livingEntity instanceof Mob) || target == null) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (!((Boolean)DreadMobConfig.dreadMobsAttackAllMobs.get()).booleanValue()) {
            event.setCanceled(true);
            return;
        }
        if (dreadLichClass != null && dreadLichClass.isInstance(mob)) {
            if (!((Boolean)DreadMobConfig.dreadLichAttackMobs.get()).booleanValue()) {
                event.setCanceled(true);
            }
        } else if (dreadThrallClass != null && dreadThrallClass.isInstance(mob)) {
            if (!((Boolean)DreadMobConfig.dreadThrallAttackMobs.get()).booleanValue()) {
                event.setCanceled(true);
            }
        } else if (dreadBeastClass != null && dreadBeastClass.isInstance(mob)) {
            if (!((Boolean)DreadMobConfig.dreadBeastAttackMobs.get()).booleanValue()) {
                event.setCanceled(true);
            }
        } else if (dreadGhoulClass != null && dreadGhoulClass.isInstance(mob)) {
            if (!((Boolean)DreadMobConfig.dreadGhoulAttackMobs.get()).booleanValue()) {
                event.setCanceled(true);
            }
        } else if (dreadScuttlerClass != null && dreadScuttlerClass.isInstance(mob)) {
            if (!((Boolean)DreadMobConfig.dreadScuttlerAttackMobs.get()).booleanValue()) {
                event.setCanceled(true);
            }
        } else if (dreadKnightClass != null && dreadKnightClass.isInstance(mob)) {
            if (!((Boolean)DreadMobConfig.dreadKnightAttackMobs.get()).booleanValue()) {
                event.setCanceled(true);
            }
        } else if (dreadHorseClass != null && dreadHorseClass.isInstance(mob) && !((Boolean)DreadMobConfig.dreadKnightHorseAttackMobs.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }
}

