/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.iceandfire.item;

import com.github.alexthe666.iceandfire.item.ItemGorgonHead;
import com.xiaoyu.suixingxiugai.config.iceandfire.item.GorgonHeadConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemGorgonHead.class})
public class ItemGorgonHeadMixin {
    @Unique
    private static final String USE_COUNT_TAG = "GorgonHeadUseCount";
    @Unique
    private static boolean successfullyTurnedToStone = false;

    @Redirect(method={"releaseUsing(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V"))
    private void redirectShrink(ItemStack stack, int amount, ItemStack stack2, Level worldIn, LivingEntity entity, int timeLeft) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return;
        }
        int maxUses = (Integer)GorgonHeadConfig.gorgonHeadUses.get();
        CompoundTag tag = stack.m_41784_();
        int currentUseCount = tag.m_128451_(USE_COUNT_TAG);
        if (++currentUseCount >= maxUses) {
            stack.m_41774_(amount);
            tag.m_128473_(USE_COUNT_TAG);
        } else {
            tag.m_128405_(USE_COUNT_TAG, currentUseCount);
        }
    }

    @Inject(method={"appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V"}, at={@At(value="HEAD")})
    private void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, CallbackInfo ci) {
        int maxUses = (Integer)GorgonHeadConfig.gorgonHeadUses.get();
        if (maxUses > 1) {
            CompoundTag tag = stack.m_41784_();
            int currentUseCount = tag.m_128451_(USE_COUNT_TAG);
            int remainingUses = maxUses - currentUseCount;
            tooltip.add((Component)Component.m_237110_((String)"item.suixingxiugai.gorgon_head.uses", (Object[])new Object[]{remainingUses}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Inject(method={"releaseUsing(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V")})
    private void onEntityTurnedToStone(ItemStack stack, Level worldIn, LivingEntity entity, int timeLeft, CallbackInfo ci) {
        successfullyTurnedToStone = true;
    }

    @Inject(method={"releaseUsing(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="TAIL")})
    private void onReleaseUsing(ItemStack stack, Level worldIn, LivingEntity entity, int timeLeft, CallbackInfo ci) {
        Player player;
        if (successfullyTurnedToStone && ((Boolean)GorgonHeadConfig.gorgonHeadPlayBreakSound.get()).booleanValue() && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_())) {
            worldIn.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        successfullyTurnedToStone = false;
    }
}

