/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.minecraft.entity;

import com.xiaoyu.suixingxiugai.config.SuixingxiugaiConfig;
import com.xiaoyu.suixingxiugai.config.twilightforest.item.WandConfig;
import com.xiaoyu.suixingxiugai.event.CriticalHitEventHandler;
import com.xiaoyu.suixingxiugai.network.DamageDisplayMessage;
import com.xiaoyu.suixingxiugai.network.NetworkHandler;
import com.xiaoyu.suixingxiugai.util.EntityTypeHelper;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)WandConfig.enableFortificationWandInvulnerability.get()).booleanValue()) {
            LivingEntity entity = (LivingEntity)this;
            try {
                Class<?> capabilityListClass = Class.forName("twilightforest.capabilities.CapabilityList");
                Object shieldsCapability = capabilityListClass.getDeclaredField("SHIELDS").get(null);
                Object lazyOptional = entity.getClass().getMethod("getCapability", Object.class).invoke((Object)entity, shieldsCapability);
                lazyOptional.getClass().getMethod("ifPresent", Consumer.class).invoke(lazyOptional, cap -> {
                    try {
                        int shieldsLeft = (Integer)cap.getClass().getMethod("shieldsLeft", new Class[0]).invoke(cap, new Object[0]);
                        if (shieldsLeft > 0) {
                            cir.cancel();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="TAIL")})
    private void onActuallyHurt(DamageSource damageSrc, float damageAmount, CallbackInfo ci) {
        boolean matchesEntityList;
        if (this instanceof Player) {
            return;
        }
        if (!((Boolean)SuixingxiugaiConfig.enableDamageNumberDisplay.get()).booleanValue()) {
            return;
        }
        LivingEntity entity = (LivingEntity)this;
        ResourceLocation entityTypeId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        String entityTypeIdStr = entityTypeId.toString();
        String entityTypeConfig = (String)SuixingxiugaiConfig.damageNumberDisplayEntityTypes.get();
        List entityListConfig = (List)SuixingxiugaiConfig.damageNumberDisplayEntities.get();
        List blacklistEntitiesConfig = (List)SuixingxiugaiConfig.damageNumberDisplayBlacklistEntities.get();
        boolean isBlacklisted = blacklistEntitiesConfig.contains(entityTypeIdStr);
        if (isBlacklisted) {
            return;
        }
        boolean matchesEntityType = EntityTypeHelper.matchesEntityType(entity, entityTypeConfig);
        boolean bl = matchesEntityList = entityListConfig.isEmpty() || entityListConfig.contains(entityTypeIdStr);
        if (!entity.m_9236_().f_46443_ && matchesEntityType && matchesEntityList && damageAmount != 0.0f) {
            boolean isCrit = false;
            if (damageSrc.m_276093_(DamageTypes.f_268464_)) {
                isCrit = CriticalHitEventHandler.isLastAttackCritical((Entity)entity);
            }
            DamageDisplayMessage message = new DamageDisplayMessage(entity, damageAmount, damageSrc, isCrit);
            NetworkHandler.sendToAllTracking((Entity)entity, message);
        }
    }
}

