/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.twilightforest.item.wand;

import com.xiaoyu.suixingxiugai.config.twilightforest.item.WandConfig;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"twilightforest.item.FortificationWandItem"})
public class FortificationWandItemMixin {
    @Inject(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUse(Level level, Player player, @Nonnull InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!((Boolean)WandConfig.enableFortificationWandTargeting.get()).booleanValue()) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41773_() >= (Integer)WandConfig.fortificationWandUses.get()) {
            cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)stack));
            return;
        }
        if (!level.m_5776_()) {
            Entity targetEntity = FortificationWandItemMixin.getEntityAtCursor(player, 20.0);
            if (targetEntity != null) {
                try {
                    Class<?> capabilityListClass = Class.forName("twilightforest.capabilities.CapabilityList");
                    Object shieldsCapability = capabilityListClass.getDeclaredField("SHIELDS").get(null);
                    LazyOptional shieldCapability = (LazyOptional)targetEntity.getClass().getMethod("getCapability", Object.class).invoke((Object)targetEntity, shieldsCapability);
                    if (((Boolean)shieldCapability.getClass().getMethod("isPresent", new Class[0]).invoke((Object)shieldCapability, new Object[0])).booleanValue()) {
                        shieldCapability.getClass().getMethod("ifPresent", Consumer.class).invoke((Object)shieldCapability, cap -> {
                            try {
                                cap.getClass().getMethod("replenishShields", new Class[0]).invoke(cap, new Object[0]);
                                cap.getClass().getMethod("setShields", Integer.TYPE, Boolean.TYPE).invoke(cap, WandConfig.fortificationWandShieldAmount.get(), true);
                                FortificationWandItemMixin.sendShieldUpdatePacket(targetEntity, cap);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    }
                }
                catch (Exception capabilityListClass) {
                    // empty catch block
                }
                if (!player.m_7500_()) {
                    try {
                        stack.getClass().getMethod("hurt", Integer.TYPE, Random.class, Object.class).invoke((Object)stack, 1, level.m_213780_(), null);
                    }
                    catch (Exception capabilityListClass) {}
                }
            } else {
                try {
                    Class<?> capabilityListClass = Class.forName("twilightforest.capabilities.CapabilityList");
                    Object shieldsCapability = capabilityListClass.getDeclaredField("SHIELDS").get(null);
                    LazyOptional shieldCapability = (LazyOptional)player.getClass().getMethod("getCapability", Object.class).invoke((Object)player, shieldsCapability);
                    if (((Boolean)shieldCapability.getClass().getMethod("isPresent", new Class[0]).invoke((Object)shieldCapability, new Object[0])).booleanValue()) {
                        shieldCapability.getClass().getMethod("ifPresent", Consumer.class).invoke((Object)shieldCapability, cap -> {
                            try {
                                cap.getClass().getMethod("replenishShields", new Class[0]).invoke(cap, new Object[0]);
                                cap.getClass().getMethod("setShields", Integer.TYPE, Boolean.TYPE).invoke(cap, WandConfig.fortificationWandShieldAmount.get(), true);
                                FortificationWandItemMixin.sendShieldUpdatePacket((Entity)player, cap);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!player.m_7500_()) {
                    try {
                        stack.getClass().getMethod("hurt", Integer.TYPE, Random.class, Object.class).invoke((Object)stack, 1, level.m_213780_(), null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (!player.m_7500_()) {
            try {
                player.getClass().getMethod("getCooldowns", new Class[0]).invoke((Object)player, new Object[0]);
                Object cooldowns = player.getClass().getMethod("getCooldowns", new Class[0]).invoke((Object)player, new Object[0]);
                cooldowns.getClass().getMethod("addCooldown", Object.class, Integer.TYPE).invoke(cooldowns, stack.m_41720_(), 1200);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cir.setReturnValue((Object)InteractionResultHolder.m_19090_((Object)stack));
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)WandConfig.fortificationWandUses.get();
    }

    private static void sendShieldUpdatePacket(Entity entity, Object cap) {
        try {
            Class<?> tfPacketHandlerClass = Class.forName("twilightforest.network.TFPacketHandler");
            Object channel = tfPacketHandlerClass.getDeclaredField("CHANNEL").get(null);
            Class<?> updateShieldPacketClass = Class.forName("twilightforest.network.UpdateShieldPacket");
            Object updateShieldPacket = updateShieldPacketClass.getConstructor(Entity.class, Object.class).newInstance(entity, cap);
            Class<?> packetDistributorClass = Class.forName("net.minecraftforge.network.PacketDistributor");
            Object trackingEntity = packetDistributorClass.getDeclaredField("TRACKING_ENTITY").get(null);
            Object target = trackingEntity.getClass().getMethod("with", Supplier.class).invoke(trackingEntity, () -> entity);
            channel.getClass().getMethod("send", Object.class, Object.class).invoke(channel, target, updateShieldPacket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Entity getEntityAtCursor(Player player, double range) {
        try {
            Vec3 srcVec = (Vec3)player.getClass().getMethod("getEyePosition", Float.TYPE).invoke((Object)player, Float.valueOf(1.0f));
            Vec3 lookVec = (Vec3)player.getClass().getMethod("getViewVector", Float.TYPE).invoke((Object)player, Float.valueOf(1.0f));
            Vec3 destVec = (Vec3)srcVec.getClass().getMethod("add", Double.TYPE, Double.TYPE, Double.TYPE).invoke((Object)srcVec, lookVec.f_82479_ * range, lookVec.f_82480_ * range, lookVec.f_82481_ * range);
            float var9 = 1.0f;
            Level level = (Level)player.getClass().getMethod("level", new Class[0]).invoke((Object)player, new Object[0]);
            Object boundingBox = player.getClass().getMethod("getBoundingBox", new Class[0]).invoke((Object)player, new Object[0]);
            Object expandedBB = boundingBox.getClass().getMethod("expandTowards", Double.TYPE, Double.TYPE, Double.TYPE).invoke(boundingBox, lookVec.f_82479_ * range, lookVec.f_82480_ * range, lookVec.f_82481_ * range);
            Object inflatedBB = expandedBB.getClass().getMethod("inflate", Double.TYPE, Double.TYPE, Double.TYPE).invoke(expandedBB, Float.valueOf(var9), Float.valueOf(var9), Float.valueOf(var9));
            List possibleList = (List)level.getClass().getMethod("getEntities", Object.class, Object.class).invoke((Object)level, player, inflatedBB);
            double hitDist = 0.0;
            Entity pointedEntity = null;
            for (Entity possibleEntity : possibleList) {
                double hitDistTemp;
                boolean isPickable = (Boolean)possibleEntity.getClass().getMethod("isPickable", new Class[0]).invoke((Object)possibleEntity, new Object[0]);
                if (!isPickable || possibleEntity == player) continue;
                float borderSize = ((Float)possibleEntity.getClass().getMethod("getPickRadius", new Class[0]).invoke((Object)possibleEntity, new Object[0])).floatValue();
                Object entityBB = possibleEntity.getClass().getMethod("getBoundingBox", new Class[0]).invoke((Object)possibleEntity, new Object[0]);
                Object collisionBB = entityBB.getClass().getMethod("inflate", Double.TYPE, Double.TYPE, Double.TYPE).invoke(entityBB, Float.valueOf(borderSize), Float.valueOf(borderSize), Float.valueOf(borderSize));
                Optional interceptPos = (Optional)collisionBB.getClass().getMethod("clip", Vec3.class, Vec3.class).invoke(collisionBB, srcVec, destVec);
                if (((Boolean)collisionBB.getClass().getMethod("contains", Vec3.class).invoke(collisionBB, srcVec)).booleanValue()) {
                    if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                    pointedEntity = possibleEntity;
                    hitDist = 0.0;
                    continue;
                }
                if (!interceptPos.isPresent() || !((hitDistTemp = ((Double)srcVec.getClass().getMethod("distanceToSqr", Vec3.class).invoke((Object)srcVec, interceptPos.get())).doubleValue()) < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = hitDistTemp;
            }
            return pointedEntity;
        }
        catch (Exception e) {
            return null;
        }
    }
}

