/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class ItemConfigHelper {
    public static boolean isItemMatchConfig(ItemStack itemStack, List<? extends String> configList) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        ResourceLocation itemKey = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemKey == null) {
            return false;
        }
        String itemString = itemKey.toString();
        String modId = itemKey.m_135827_();
        for (String string : configList) {
            if (string.startsWith("# ") || !(string.contains("&&") || string.contains("/") ? ItemConfigHelper.isMultiItemContains(itemStack, itemString, modId, string) : ItemConfigHelper.isItemMatch(itemStack, itemString, modId, string))) continue;
            return true;
        }
        return false;
    }

    private static boolean isMultiItemContains(ItemStack itemStack, String itemString, String modId, String multiItemConfig) {
        String[] requiredItems;
        for (String item : requiredItems = multiItemConfig.contains("&&") ? multiItemConfig.split("&&") : multiItemConfig.split("/")) {
            String trimmedItem = item.trim();
            if (!ItemConfigHelper.isItemMatch(itemStack, itemString, modId, trimmedItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWearingArmorFromConfig(LivingEntity entity, List<? extends String> configList) {
        return ItemConfigHelper.isWearingItemsFromConfig(entity, configList, ItemConfigHelper::isSingleArmorEquipped, ItemConfigHelper::isWearingRequiredArmorSet);
    }

    public static boolean isWearingCuriosFromConfig(LivingEntity entity, List<? extends String> configList) {
        return ItemConfigHelper.isWearingItemsFromConfig(entity, configList, ItemConfigHelper::isSingleCurioEquipped, ItemConfigHelper::isWearingRequiredCuriosSet);
    }

    private static boolean isWearingItemsFromConfig(LivingEntity entity, List<? extends String> configList, BiPredicate<LivingEntity, String> singleItemChecker, BiPredicate<LivingEntity, String> multiItemChecker) {
        for (String string : configList) {
            if (string.startsWith("# ") || !(string.contains("&&") || string.contains("/") ? multiItemChecker.test(entity, string) : singleItemChecker.test(entity, string))) continue;
            return true;
        }
        return false;
    }

    private static boolean isItemMatch(ItemStack itemStack, String itemString, String modId, String itemConfig) {
        if (itemStack.m_41619_()) {
            return false;
        }
        if (itemConfig.startsWith("#") && itemConfig.length() <= 1) {
            return false;
        }
        if (itemConfig.startsWith("@")) {
            String configModId = itemConfig.substring(1);
            return configModId.equals(modId);
        }
        if (itemConfig.startsWith("#") && itemConfig.length() > 1 && !itemConfig.startsWith("# ")) {
            String tagPath;
            String tagNamespace;
            String tagString = itemConfig.substring(1);
            String[] parts = tagString.split(":", 2);
            if (parts.length == 2) {
                tagNamespace = parts[0];
                tagPath = parts[1];
            } else {
                tagNamespace = "minecraft";
                tagPath = tagString;
            }
            ResourceLocation tagLocation = new ResourceLocation(tagNamespace, tagPath);
            TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)tagLocation);
            return itemStack.m_204117_(tagKey);
        }
        return itemConfig.equals(itemString);
    }

    private static boolean isSingleArmorEquipped(LivingEntity entity, String armorConfig) {
        EquipmentSlot[] slots;
        for (EquipmentSlot slot : slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            ItemStack itemStack = entity.m_6844_(slot);
            if (!ItemConfigHelper.isItemMatchForSlot(itemStack, armorConfig)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSingleCurioEquipped(LivingEntity entity, String curioConfig) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(handler -> !handler.findCurios(stack -> ItemConfigHelper.isItemMatchForSlot(stack, curioConfig)).isEmpty()).orElse(false);
    }

    private static boolean isItemMatchForSlot(ItemStack itemStack, String itemConfig) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        ResourceLocation itemKey = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemKey != null) {
            String itemString = itemKey.toString();
            String modId = itemKey.m_135827_();
            return ItemConfigHelper.isItemMatch(itemStack, itemString, modId, itemConfig);
        }
        return false;
    }

    private static boolean isWearingRequiredArmorSet(LivingEntity entity, String armorSetConfig) {
        return ItemConfigHelper.isWearingRequiredItemSet(entity, armorSetConfig, false);
    }

    private static boolean isWearingRequiredCuriosSet(LivingEntity entity, String curioSetConfig) {
        return ItemConfigHelper.isWearingRequiredItemSet(entity, curioSetConfig, true);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isWearingRequiredItemSet(LivingEntity entity, String itemSetConfig, boolean isCurios) {
        void var8_10;
        String[] requiredItems = itemSetConfig.contains("&&") ? itemSetConfig.split("&&") : itemSetConfig.split("/");
        HashMap<String, Integer> requiredCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> foundCounts = new HashMap<String, Integer>();
        String[] stringArray = requiredItems;
        int n = stringArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            String item = stringArray[var8_10];
            String trimmedItem = item.trim();
            requiredCounts.put(trimmedItem, requiredCounts.getOrDefault(trimmedItem, 0) + 1);
            foundCounts.put(trimmedItem, 0);
            ++var8_10;
        }
        EquipmentSlot[] slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        for (EquipmentSlot slot : slots) {
            ItemStack itemStack = entity.m_6844_(slot);
            ItemConfigHelper.checkItemSlot(itemStack, foundCounts, requiredCounts);
        }
        if (isCurios) {
            CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        ItemStack stack = stacksHandler.getStacks().getStackInSlot(i);
                        ItemConfigHelper.checkItemSlot(stack, foundCounts, requiredCounts);
                    }
                }
            });
        }
        for (Map.Entry entry : requiredCounts.entrySet()) {
            String requiredItem = (String)entry.getKey();
            int requiredCount = (Integer)entry.getValue();
            int foundCount = foundCounts.getOrDefault(requiredItem, 0);
            if (foundCount >= requiredCount) continue;
            return false;
        }
        return true;
    }

    private static void checkItemSlot(ItemStack itemStack, Map<String, Integer> foundCounts, Map<String, Integer> requiredCounts) {
        Item item;
        ResourceLocation itemKey;
        if (!itemStack.m_41619_() && (itemKey = ForgeRegistries.ITEMS.getKey((Object)(item = itemStack.m_41720_()))) != null) {
            String itemString = itemKey.toString();
            String modId = itemKey.m_135827_();
            for (String requiredItem : requiredCounts.keySet()) {
                if (!ItemConfigHelper.isItemMatch(itemStack, itemString, modId, requiredItem)) continue;
                int currentCount = foundCounts.getOrDefault(requiredItem, 0);
                foundCounts.put(requiredItem, currentCount + 1);
            }
        }
    }
}

