/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.twilightforest.entity.boss;

import com.xiaoyu.suixingxiugai.config.SuixingxiugaiConfig;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import twilightforest.entity.boss.Lich;
import twilightforest.init.TFSounds;

@Mixin(value={Lich.class})
public abstract class LichMixin {
    @Shadow
    private ServerBossEvent bossInfo;

    @Accessor(value="SHIELD_STRENGTH")
    public static EntityDataAccessor<Integer> getShieldStrengthAccessor() {
        throw new AssertionError();
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Ltwilightforest/entity/boss/Lich;getShieldStrength()I", ordinal=0)}, cancellable=true)
    private void suixingxiugai$handlePhysicalDamageShield(DamageSource src, float damage, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)SuixingxiugaiConfig.enableLichShieldModification.get()).booleanValue()) {
            return;
        }
        Lich lich = (Lich)this;
        if (lich.getShieldStrength() > 0 && this.isEntityCausedDamage(src)) {
            lich.setShieldStrength(lich.getShieldStrength() - 1);
            lich.m_5496_((SoundEvent)TFSounds.SHIELD_BREAK.get(), 1.0f, lich.m_6100_() * 2.0f);
            lich.m_146850_(GameEvent.f_223706_);
            cir.cancel();
            cir.setReturnValue((Object)false);
        }
    }

    private boolean isEntityCausedDamage(DamageSource source) {
        Entity directEntity = source.m_7640_();
        Entity entity = source.m_7639_();
        return directEntity != null || entity != null;
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void suixingxiugai$modifyInitialShieldStrength(CallbackInfo ci) {
        Lich lich = (Lich)this;
        SynchedEntityData entityData = lich.m_20088_();
        entityData.m_135381_(LichMixin.getShieldStrengthAccessor(), (Object)((Integer)SuixingxiugaiConfig.lichShieldStrength.get()));
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerBossEvent;setProgress(F)V", ordinal=0, shift=At.Shift.AFTER)})
    private void suixingxiugai$modifyShieldPhaseBossBar(CallbackInfo ci) {
        Lich lich = (Lich)this;
        if (!lich.m_9236_().m_5776_() && lich.getPhase() == 1) {
            int maxShield = (Integer)SuixingxiugaiConfig.lichShieldStrength.get();
            float progress = (float)lich.getShieldStrength() / (float)maxShield;
            this.bossInfo.m_142711_(Math.max(0.0f, Math.min(1.0f, progress)));
            if (maxShield > 6 && this.bossInfo.m_18863_() == BossEvent.BossBarOverlay.NOTCHED_6) {
                this.bossInfo.m_5648_(BossEvent.BossBarOverlay.PROGRESS);
            }
        }
    }
}

