/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.iceandfire.item;

import com.github.alexthe666.iceandfire.entity.props.EntityDataProvider;
import com.github.alexthe666.iceandfire.item.ItemDeathwormGauntlet;
import com.xiaoyu.suixingxiugai.config.iceandfire.item.DeathwormGauntletConfig;
import com.xiaoyu.suixingxiugai.util.DeathwormGauntletCooldownHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ItemDeathwormGauntlet.class})
public abstract class DeathwormGauntletMixin {
    @Shadow
    private boolean deathwormReceded;
    @Shadow
    private boolean deathwormLaunched;
    @Shadow
    private int specialDamage;

    @Overwrite
    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        EntityDataProvider.getCapability((Entity)entity).ifPresent(data -> {
            int tempLungeTicks = data.miscData.lungeTicks;
            if (this.deathwormReceded) {
                if (tempLungeTicks > 0) {
                    tempLungeTicks -= 4;
                }
                if (tempLungeTicks <= 0) {
                    tempLungeTicks = 0;
                    this.deathwormReceded = false;
                    this.deathwormLaunched = false;
                }
            } else if (this.deathwormLaunched && (tempLungeTicks = 4 + tempLungeTicks) > 20) {
                this.deathwormReceded = true;
            }
            if (data.miscData.lungeTicks == 20 && entity instanceof Player) {
                Player player = (Player)entity;
                if (!DeathwormGauntletCooldownHandler.canUseGauntlet(player)) {
                    data.miscData.setLungeTicks(tempLungeTicks);
                    return;
                }
                Vec3 vector3d = player.m_20252_(1.0f).m_82541_();
                double range = (Double)DeathwormGauntletConfig.DEATHWORM_GAUNTLET_RANGE.get();
                for (LivingEntity livingEntity : world.m_45976_(LivingEntity.class, new AABB(player.m_20185_() - range, player.m_20186_() - range, player.m_20189_() - range, player.m_20185_() + range, player.m_20186_() + range, player.m_20189_() + range))) {
                    if (livingEntity == entity) continue;
                    Vec3 vector3d1 = new Vec3(livingEntity.m_20185_() - player.m_20185_(), livingEntity.m_20186_() - player.m_20186_(), livingEntity.m_20189_() - player.m_20189_());
                    double d0 = vector3d1.m_82553_();
                    double d1 = vector3d.m_82526_(vector3d1 = vector3d1.m_82541_());
                    boolean canSee = d1 > 1.0 - 0.5 / d0 && player.m_142582_((Entity)livingEntity);
                    if (!canSee) continue;
                    ++this.specialDamage;
                    livingEntity.m_6469_(entity.m_9236_().m_269111_().m_269075_((Player)entity), ((Double)DeathwormGauntletConfig.DEATHWORM_GAUNTLET_DAMAGE.get()).floatValue());
                    DeathwormGauntletCooldownHandler.setCooldown(player);
                    double pullForce = (Double)DeathwormGauntletConfig.DEATHWORM_GAUNTLET_PULL_FORCE.get();
                    if (((Boolean)DeathwormGauntletConfig.DEATHWORM_GAUNTLET_KNOCKBACK_RESISTANCE_REDUCTION.get()).booleanValue()) {
                        pullForce *= 1.0 - Math.min(1.0, livingEntity.m_21133_(Attributes.f_22278_));
                    }
                    livingEntity.m_5997_((player.m_20185_() - livingEntity.m_20185_()) * pullForce, (player.m_20186_() - livingEntity.m_20186_()) * pullForce, (player.m_20189_() - livingEntity.m_20189_()) * pullForce);
                }
            }
            data.miscData.setLungeTicks(tempLungeTicks);
        });
    }
}

