/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.iceandfire.item;

import com.github.alexthe666.iceandfire.item.ItemHydraHeart;
import com.xiaoyu.suixingxiugai.config.curios.iceandfire.HydraHeartConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mixin(value={ItemHydraHeart.class})
public class ItemHydraHeartMixin {
    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInventoryTickHead(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected, CallbackInfo ci) {
        Player player;
        if (entity instanceof Player) {
            player = (Player)entity;
            if (itemSlot >= 0 && itemSlot <= 8) {
                this.applyHydraHeartEffect(player, stack);
                ci.cancel();
                return;
            }
        }
        if (((Boolean)HydraHeartConfig.hydraHeartWorkAsCurio.get()).booleanValue() && entity instanceof Player && this.isWornAsCurio(player = (Player)entity, stack)) {
            this.applyHydraHeartEffect(player, stack);
            ci.cancel();
        }
    }

    private boolean isWornAsCurio(Player player, ItemStack stack) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(inv -> inv.findFirstCurio(itemStack -> itemStack == stack)).isPresent();
    }

    private void applyHydraHeartEffect(Player player, ItemStack stack) {
        double healthPercentage = player.m_21223_() / Math.max(1.0f, player.m_21233_());
        if (healthPercentage < 1.0) {
            int potionLevel = this.getPotionLevelFromConfig(healthPercentage);
            if (((Boolean)com.xiaoyu.suixingxiugai.config.iceandfire.item.HydraHeartConfig.hydraHeartStackPotionLevels.get()).booleanValue()) {
                potionLevel = this.getTotalPotionLevel(player, healthPercentage);
            }
            int potionDuration = (Integer)com.xiaoyu.suixingxiugai.config.iceandfire.item.HydraHeartConfig.hydraHeartPotionDuration.get();
            String potionEffectId = (String)com.xiaoyu.suixingxiugai.config.iceandfire.item.HydraHeartConfig.hydraHeartPotionEffect.get();
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)potionEffectId));
            if (effect != null && potionLevel >= 0 && (((Boolean)com.xiaoyu.suixingxiugai.config.iceandfire.item.HydraHeartConfig.hydraHeartApplyEffectIfAlreadyHas.get()).booleanValue() || !player.m_21023_(effect))) {
                player.m_7292_(new MobEffectInstance(effect, potionDuration, potionLevel, true, false));
            }
        }
    }

    private int getTotalPotionLevel(Player player, double healthPercentage) {
        int totalLevel = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof ItemHydraHeart)) continue;
            totalLevel += this.getPotionLevelFromConfig(healthPercentage);
        }
        if (((Boolean)HydraHeartConfig.hydraHeartWorkAsCurio.get()).booleanValue()) {
            totalLevel += this.getCurioPotionLevels(player, healthPercentage);
        }
        return totalLevel;
    }

    private int getCurioPotionLevels(Player player, double healthPercentage) {
        int levels = 0;
        Optional curiosInv = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        if (curiosInv.isPresent()) {
            ICuriosItemHandler inv = (ICuriosItemHandler)curiosInv.get();
            for (Map.Entry entry : inv.getCurios().entrySet()) {
                ICurioStacksHandler curio = (ICurioStacksHandler)entry.getValue();
                for (int i = 0; i < curio.getStacks().getSlots(); ++i) {
                    ItemStack stack = curio.getStacks().getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof ItemHydraHeart)) continue;
                    levels += this.getPotionLevelFromConfig(healthPercentage);
                }
            }
        }
        return levels;
    }

    private int getPotionLevelFromConfig(double healthPercentage) {
        List thresholds = (List)com.xiaoyu.suixingxiugai.config.iceandfire.item.HydraHeartConfig.hydraHeartPotionThresholds.get();
        List levels = (List)com.xiaoyu.suixingxiugai.config.iceandfire.item.HydraHeartConfig.hydraHeartPotionLevels.get();
        if (thresholds.size() + 1 != levels.size()) {
            return 0;
        }
        for (int i = 0; i < thresholds.size(); ++i) {
            if (!(healthPercentage > (Double)thresholds.get(i))) continue;
            return (Integer)levels.get(i);
        }
        return (Integer)levels.get(levels.size() - 1);
    }
}

