/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.mixin.server.twilightforest.entity.boss;

import com.xiaoyu.suixingxiugai.config.twilightforest.entity.NagaConfig;
import com.xiaoyu.suixingxiugai.entity.ai.goal.TeleportToHomeGoal;
import com.xiaoyu.suixingxiugai.util.twilightforest.entity.NagaPhysicsUtil;
import java.util.function.Consumer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import twilightforest.entity.ai.goal.NagaMovementPattern;
import twilightforest.entity.boss.Naga;

@Mixin(value={Naga.class})
public class NagaMixin {
    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void modifyAttributes(CallbackInfo ci) {
        AttributeInstance knockbackResistanceAttribute;
        AttributeInstance followRangeAttribute;
        AttributeInstance attackDamageAttribute;
        AttributeInstance movementSpeedAttribute;
        Naga naga = (Naga)this;
        AttributeInstance maxHealthAttribute = naga.m_21051_(Attributes.f_22276_);
        if (maxHealthAttribute != null) {
            maxHealthAttribute.m_22100_(((Double)NagaConfig.nagaMaxHealth.get()).doubleValue());
        }
        if ((movementSpeedAttribute = naga.m_21051_(Attributes.f_22279_)) != null) {
            movementSpeedAttribute.m_22100_(((Double)NagaConfig.nagaMovementSpeed.get()).doubleValue());
        }
        if ((attackDamageAttribute = naga.m_21051_(Attributes.f_22281_)) != null) {
            attackDamageAttribute.m_22100_(((Double)NagaConfig.nagaAttackDamage.get()).doubleValue());
        }
        if ((followRangeAttribute = naga.m_21051_(Attributes.f_22277_)) != null) {
            followRangeAttribute.m_22100_(((Double)NagaConfig.nagaFollowRange.get()).doubleValue());
        }
        if ((knockbackResistanceAttribute = naga.m_21051_(Attributes.f_22278_)) != null) {
            knockbackResistanceAttribute.m_22100_(((Double)NagaConfig.nagaKnockbackResistance.get()).doubleValue());
        }
    }

    @ModifyConstant(method={"customServerAiStep"}, constant={@Constant(intValue=15)})
    private int modifyStunDamageThreshold(int original) {
        return (Integer)NagaConfig.nagaStunDamageThreshold.get();
    }

    @ModifyConstant(method={"<init>"}, constant={@Constant(intValue=217)})
    private int modifyXpReward(int original) {
        return (Integer)NagaConfig.nagaXpReward.get();
    }

    @ModifyConstant(method={"finalizeSpawn"}, constant={@Constant(doubleValue=80.0)})
    private double modifyNormalDifficultyHealthBoost(double original) {
        return ((Integer)NagaConfig.nagaDifficultyHealthBoostNormal.get()).intValue();
    }

    @ModifyConstant(method={"finalizeSpawn"}, constant={@Constant(doubleValue=130.0)})
    private double modifyHardDifficultyHealthBoost(double original) {
        return ((Integer)NagaConfig.nagaDifficultyHealthBoostHard.get()).intValue();
    }

    @ModifyConstant(method={"customServerAiStep"}, constant={@Constant(intValue=600)})
    private int modifyHealingDelay(int original) {
        return (Integer)NagaConfig.nagaHealingDelay.get();
    }

    @ModifyConstant(method={"doHurtTarget"}, constant={@Constant(intValue=200)})
    private int modifyShieldCooldown(int original) {
        return (Integer)NagaConfig.nagaShieldCooldown.get();
    }

    @Redirect(method={"doHurtTarget"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V", ordinal=0))
    private void redirectNormalShieldDamage(ItemStack instance, int amount, LivingEntity entity, Consumer<LivingEntity> onBroken) {
        instance.m_41622_(((Integer)NagaConfig.nagaShieldDamageOnCharge.get()).intValue(), entity, onBroken);
    }

    @Redirect(method={"doHurtTarget"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V", ordinal=1))
    private void redirectEnragedShieldDamage(ItemStack instance, int amount, LivingEntity entity, Consumer<LivingEntity> onBroken) {
        instance.m_41622_(((Integer)NagaConfig.nagaShieldDamageOnChargeEnraged.get()).intValue(), entity, onBroken);
    }

    @Redirect(method={"doHurtTarget"}, at=@At(value="INVOKE", target="Ltwilightforest/entity/boss/Naga;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", ordinal=0))
    private boolean redirectNagaSelfDamage(Naga naga, DamageSource source, float amount) {
        if (naga.getMovementAI() != null && naga.getMovementAI().getState() == NagaMovementPattern.MovementState.STUNLESS_CHARGE) {
            return naga.m_6469_(source, ((Double)NagaConfig.nagaAttackKnockbackForceEnraged.get()).floatValue());
        }
        return naga.m_6469_(source, ((Double)NagaConfig.nagaAttackKnockbackForce.get()).floatValue());
    }

    @Redirect(method={"doHurtTarget"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean redirectEnragedPlayerDamage(LivingEntity instance, DamageSource source, float amount) {
        Naga naga;
        boolean result = instance.m_6469_(source, amount);
        Entity entity = source.m_7640_();
        if (entity instanceof Naga && (naga = (Naga)entity).getMovementAI() != null && naga.getMovementAI().getState() == NagaMovementPattern.MovementState.STUNLESS_CHARGE) {
            naga.m_6469_(naga.m_269291_().m_269264_(), ((Double)NagaConfig.nagaAttackKnockbackForceEnraged.get()).floatValue());
        }
        return result;
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Ltwilightforest/entity/boss/Naga;isMobWithinHomeArea(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean redirectAllIsMobWithinHomeAreaCalls(Naga naga, Entity entity) {
        return NagaPhysicsUtil.isEntityWithinNagaCourtyard(naga, entity);
    }

    @Redirect(method={"doHurtTarget"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;push(DDD)V"))
    private void redirectNagaRecoilPush(Entity instance, double x, double y, double z) {
        Naga naga = (Naga)this;
        if (instance == naga) {
            float yRot = naga.m_146908_();
            double recoilForce = (Double)NagaConfig.nagaHeadChargeRecoilForce.get();
            double recoilX = (double)(-Mth.m_14031_((float)(yRot * (float)Math.PI / 180.0f))) * recoilForce;
            double recoilY = (double)0.4f * recoilForce;
            double recoilZ = (double)Mth.m_14089_((float)(yRot * (float)Math.PI / 180.0f)) * recoilForce;
            naga.m_5997_(recoilX, recoilY, recoilZ);
        } else {
            NagaPhysicsUtil.applyHeadPushAndRecoilForces(naga, instance);
        }
    }

    @Redirect(method={"registerGoals"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V", ordinal=4))
    private void redirectAddAttemptToGoHomeGoal(GoalSelector goalSelector, int priority, Goal goal) {
        Naga naga = (Naga)this;
        goalSelector.m_25352_(priority, new TeleportToHomeGoal<Naga>(naga, 1.0));
    }

    @Redirect(method={"customServerAiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/tags/TagKey;)Z", ordinal=0))
    private boolean redirectLeafBlockCheckInCustomServerAiStep(BlockState state, TagKey<Block> tagKey) {
        if (!((Boolean)NagaConfig.nagaCanDestroyBlocks.get()).booleanValue()) {
            return false;
        }
        return state.m_204336_(tagKey);
    }

    @Redirect(method={"customServerAiStep"}, at=@At(value="INVOKE", target="Ltwilightforest/entity/boss/Naga;shouldDestroyAllBlocks()Z", ordinal=0))
    private boolean redirectShouldDestroyAllBlocksForMinY(Naga naga) {
        if (naga.isCharging() && !((Boolean)NagaConfig.nagaCanDestroyBlocksOnCharge.get()).booleanValue()) {
            return false;
        }
        return naga.shouldDestroyAllBlocks();
    }

    @Redirect(method={"customServerAiStep"}, at=@At(value="INVOKE", target="Ltwilightforest/entity/boss/Naga;shouldDestroyAllBlocks()Z", ordinal=1))
    private boolean redirectShouldDestroyAllBlocksForBlockDestruction(Naga naga) {
        if (naga.isCharging() && !((Boolean)NagaConfig.nagaCanDestroyBlocksOnCharge.get()).booleanValue()) {
            return false;
        }
        return naga.shouldDestroyAllBlocks();
    }

    @ModifyVariable(method={"tickDeath"}, at=@At(value="STORE"), ordinal=0)
    private int modifyRenderEnd(int original) {
        return (Integer)NagaConfig.nagaDeathAnimationStartDelay.get();
    }

    @ModifyVariable(method={"tickDeath"}, at=@At(value="STORE"), ordinal=1)
    private int modifyMaxDeath(int original) {
        int startDelay = (Integer)NagaConfig.nagaDeathAnimationStartDelay.get();
        int duration = (Integer)NagaConfig.nagaDeathAnimationDuration.get();
        return startDelay + duration;
    }
}

