/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.util;

import com.xiaoyu.suixingxiugai.gamerule.SuixingxiugaiGameRules;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BlockOwnerTracker {
    private static final Map<BlockPos, UUID> blockOwners = new ConcurrentHashMap<BlockPos, UUID>();
    private static final Map<Level, Map<BlockPos, UUID>> worldBlockOwners = new ConcurrentHashMap<Level, Map<BlockPos, UUID>>();

    public static void setBlockOwner(BlockPos pos, UUID ownerUUID) {
        blockOwners.put(pos, ownerUUID);
    }

    @Nullable
    public static UUID getBlockOwner(BlockPos pos) {
        return blockOwners.get(pos);
    }

    public static boolean isBlockOwner(BlockPos pos, Player player) {
        if (!player.m_9236_().m_46469_().m_46207_(SuixingxiugaiGameRules.ICE_AND_FIRE_DRAGON_PVP)) {
            UUID ownerUUID = BlockOwnerTracker.getBlockOwner(pos);
            return ownerUUID != null && ownerUUID.equals(player.m_20148_());
        }
        return false;
    }

    public static void removeBlockOwner(BlockPos pos) {
        blockOwners.remove(pos);
    }

    public static void clearWorldBlockOwners(Level level) {
        worldBlockOwners.remove(level);
    }
}

