/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyu.suixingxiugai.event;

import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.player.CriticalHitEvent;

public class CriticalHitEventHandler {
    private static Entity lastCriticalTarget = null;
    private static long lastCriticalTime = 0L;

    public static void onCriticalHit(CriticalHitEvent event) {
        if (!event.isCanceled() && event.getDamageModifier() > 1.0f) {
            lastCriticalTarget = event.getTarget();
            lastCriticalTime = System.currentTimeMillis();
        }
    }

    public static boolean isLastAttackCritical(Entity target) {
        boolean isCrit;
        boolean bl = isCrit = lastCriticalTarget == target && System.currentTimeMillis() - lastCriticalTime < 200L;
        if (isCrit) {
            return true;
        }
        if (System.currentTimeMillis() - lastCriticalTime >= 200L) {
            CriticalHitEventHandler.clearCriticalRecord();
        }
        return false;
    }

    private static void clearCriticalRecord() {
        lastCriticalTarget = null;
        lastCriticalTime = 0L;
    }
}

